<?php

require realpath ( __DIR__ . '/lib/load.php' );

if ( isset ( $_GET ['lang'] ) ) {

	$_f -> setLang ( $_GET ['lang'] );
	header ( "Location: " . strtok ( $_SERVER ['REQUEST_URI'], '?' ), true, 303 );
	exit ();

}

$ref = null;

if ( !isset ( $_GET ['form'] ) ) {
	if ( !isset ( $_GET ['ref'] ) ) {
		header ( 'location: ' . $_f->getConfig('redirect') );
 		exit();
	}
	$ref = $_GET ['ref'];
}

if ( !$ref ) {
	$_GET ['form'] = explode ( '-', $_GET ['form'] );
	$_GET ['form'] = $_GET ['form'] [0];
}

$_s = new SQLite3(DIR . md5('SES') . '.db', SQLITE3_OPEN_READWRITE);

if ( $ref ) {

	$check = $_s->query("SELECT COUNT(*) AS `total` FROM `apartment` WHERE `ref` = '{$ref}'")->fetchArray(1);

	if ( !$check['total'] ) {
		header ( "Location: " . $_f->getConfig('redirect') );
		exit ();
	}

	$check = [
		'total' => 0,
		'id' => (int) 0,
		't' => 'newTenant',
		'ref' => $ref,
		'reservation' => '',
		'start' => time (),
		'end' => time (),
		'data' => "[]",
		'tenants' => "[]"
	];
} else {
	$check = $_s->query("SELECT *, COUNT(*) AS `total` FROM `register` WHERE `data` LIKE '%\"" . $_s->escapeString($_GET ['form']) . "\"%' AND `data` LIKE '%\"entry\":\"\"%'")->fetchArray(1);
	$check['t'] = 'publicTenant';
}

if ($check['total']==0) {
	if (!$ref) {
		header ( 'location: ' . $_f->getConfig('redirect') );
		exit();
	}
}

$data = [
	'id' => $check ['id'],
	'ref' => $check ['ref'],
	'reservation' => $check ['reservation'],
	'start' => date ( 'd / m / Y', $check ['start'] ),
	'end' => date ( 'd / m / Y', $check ['end'] ),
	'data' => json_decode ( $check ['data'], 1 ),
	'tenants' => json_decode ( $check ['tenants'], 1 )
];

$getApartment = $_s->query("SELECT `name` FROM `apartment` WHERE `ref` = '" . ( $ref ?? $data ['ref'] ) . "'")->fetchArray(1);

$langList = json_decode(file_get_contents(LIB.'co-co.json'),1);

$_f -> loadTemplate ( TPL . 'tenant.html', [
	'file' 				=> 'tenant.json',

	'langLib' 			=> file_get_contents ( LNG . $_f -> getLang () . DIRECTORY_SEPARATOR . 'tenant.json' ),
	'tenants' 			=> json_encode ( $data ['tenants'], JSON_UNESCAPED_UNICODE ),
	'ref' 				=> $data ['ref'],
	'date'				=> time (),

	'areLangs'			=> call_user_func(function() use($_f) {

		$available = array_filter ( scandir ( LNG ), fn( $d ) => $d [0] !== '.' );
		unset($available[array_search($_f->getLang(),$available)]);

		return count ( $available ) ? '' : ' disabled';

	}),
	'actualLang'		=> call_user_func(function() use ($_f,$langList) {

		$l = $_f->getLang() === 'en' ? 'gb' : $_f->getLang();
		$filtered = array_filter($langList, fn($v) => $v['alpha2Code'] === strtoupper($l));
		$filtered = reset($filtered);
		return mb_convert_case($filtered ['languages'][0]['nativeName'], MB_CASE_TITLE, 'UTF-8');

	}),
	'langs'				=> call_user_func(function() use($_http,$_f,$ref,$langList) {

		$available = array_filter ( scandir ( LNG ), fn( $d ) => $d [0] !== '.' );
		unset($available[array_search($_f->getLang(),$available)]);

		$ret = '';

		if(count($available)) {
			$ret .= '<ul class="dropdown-menu">';
			foreach($available as $v) {
				$v = $v === 'en' ? 'gb' : $v;
				foreach($langList as $l) {
					if($l['alpha2Code']===strtoupper($v)){
						$v = $v === 'gb' ? 'en' : $v;
						$url = $_http;
						$url .= !$ref ? "form/{$_GET ['form']}-{$GLOBALS['data']['ref']}" : "{$ref}/form";
						$url .= "?" . http_build_query ( ['lang' => $v] );
						$ret .= '<li><a class="dropdown-item" href="' . $url . '"><img src="' . ($l['flags']['svg']??'') . '" alt="' . $v . '" class="img-fluid me-2"/>' . mb_convert_case($l['languages'][0]['nativeName'], MB_CASE_TITLE, 'UTF-8') . '</a></li>';
						break;
					}
				}
			}
			$ret .= '</ul>';
		}

		return $ret;

	}),

	'apartName' 		=> $getApartment['name'] ?? '',
	'isReservation' 	=> !$ref ? 'text-center' : 'd-none',
	'reservationNr' 	=> $data ['reservation'],
	'd-none' 			=> !$ref ? 'd-none' : '',
	'isNew' 			=> !$ref ? 'd-flex flex-wrap justify-content-between align-items-center' : 'd-none',
	'checkin' 			=> $data ['start'] ?? '',
	'checkout' 			=> $data ['end'] ?? '',

	'id' 				=> $data ['id'],
	't' 				=> $check ['t']
] );

$_f->build();

?>