<?php

/**
 * title = TITULO
 * distance = DISTANCIA EN METROS
 * address = DIRECCION
 * lat = LATITUD
 * lng = LONGITUD
 * phone = TELEFONO 00
 * whatsapp = WHATSAPP +
 * email = CORREO ELECTRONICO
 */

// {"title":"","distance":"","address":"","lat":"","lng":"","phone":"","whatsapp":"","email":""}

class apart
{

	private $html = [];
	private $data = [];
	private $lang = null;
	private $_s = null;
	private $_r = null;
	private $_log = false;
	private $_http = null;
	protected $_ = null;
	private $redirect = 'https://grupoquattro.com';

	function __construct($ref = null)
	{

		$forceLang = $_GET ['lang'] ?? null;
		$this->lang($forceLang);

		if($forceLang !== null) {
			$url = strtok($_SERVER['REQUEST_URI'],'?');
			header("Location:{$url}",true,303);
			exit();
		}

		$this->_s = new SQLite3(__DIR__ . '/../a2c8b94f599785951d6bc8622b5187f1.db', SQLITE3_OPEN_READWRITE);
		$this->_r = new SQLite3(__DIR__ . '/../3bb2242795d28419b6d308a25755f468.db', SQLITE3_OPEN_READWRITE);
		$this->_http = $GLOBALS ['_http'];

		// $check = $this->_r->query("SELECT *, COUNT(*) AS `total` FROM `log` WHERE `ref` = '{$_GET['ref']}' AND ('" . strtotime('now') . "' BETWEEN `start` AND `end`) AND `checkin` = ''")->fetchArray(1);
		// if ($check['total'] == 1) {
		// 	$this->_log = true;
		// }

		$this->data = $this->_s->query("SELECT *, COUNT(*) AS `total` FROM `apart` WHERE `ref` = '" . $this->_s->escapeString( $ref ?? $_GET['ref'] ) . "'" . (!isset($_COOKIE['login']) ? " AND `active` = '1'" : "") . " AND `deleted` = '0' LIMIT 1")->fetchArray(1);

		if ($this->data['total'] !== 1) {

			header('location: ' . $this -> redirect);
			$this->_s->close();
			exit();

		}

		foreach ($this->data as $k => $v) {

			if ($k != 'id' && $k != 'ref' && $k != 'name' && $k != 'box' && $k != 'active' && $k != 'deleted' && $k != 'total') {
				$this->data[$k] = json_decode($v, 1);
			}

		}

		$dir = scandir(__DIR__ . '/../lang/');
		unset($dir[0], $dir[1]);

		foreach ($dir as $v) {

			if (!isset($this->data['description'][$v])) {
				$this->data['description'][$v] = "";
			}

			if (!isset($this->data['conditions'][$v])) {
				$this->data['conditions'][$v] = [];
			}

			if (!isset($this->data['collect_key'][$v])) {
				$this->data['collect_key'][$v] = "";
			}

			if (!isset($this->data['to_apartment'][$v])) {
				$this->data['to_apartment'][$v] = "";
			}

			if (!isset($this->data['left_key'][$v])) {
				$this->data['left_key'][$v] = "";
			}

			if (!isset($this->data['garage'][$v])) {
				$this->data['garage'][$v] = "";
			}

		}

		$this->timeOutCheckIn();

		$this->html[] = "<!DOCTYPE HTML>";
		$this->html[] = "<html lang='{$this->lang[0]}'>";
		$this->meta();
		$this->html[] = "<body>";
		$this->html[] = "<section class='container accordion mb-3' id='accordion'>";
		$this->header();

	}

	protected function timeOutCheckIn()
	{

		$check = $this->_r->query("SELECT COUNT(*) AS `total` FROM `log` WHERE `ref` = '{$_GET['ref']}' AND ('" . strtotime('now') . "' BETWEEN `start` AND `end`)")->fetchArray();

		if ($check['total'] > 0) {

			$check = $this->_r->query("SELECT * FROM `log` WHERE `ref` = '{$_GET['ref']}' AND ('" . strtotime('now') . "' BETWEEN `start` AND `end`)");

			while ($r = $check->fetchArray(1)) {

				if (strtotime('now') > ($r['start'] + (60 * 60 * 36))) {
					$this->_s->query("UPDATE `apart` SET `box` = '0' WHERE `ref` = '{$_GET['ref']}'");
					$this->data['box'] = 0;
				}

			}

		}

	}

	protected function minimize($html)
	{

		return preg_replace([
			'/(\n|^)(\x20+|\t)/',
			'/(\n|^)\/\/(.*?)(\n|$)/',
			'/\n/',
			'/\<\!--.*?-->/',
			'/(\x20+|\t)/',
			'/\>\s+\</',
			'/(\"|\')\s+\>/',
			'/=\s+(\"|\')/'
		], [
			"\n",
			"\n",
			" ",
			"",
			" ",
			"><",
			"$1>",
			"=$1"
		], $html);

	}

	protected function getImg($id, $return = 'base64')
	{

		$query = $this->_s->query("SELECT *, COUNT(`id`) AS `total` FROM `images` WHERE `id` = '{$id}'")->fetchArray(1);
		if ($query['total'] < 1) {
			return false;
		}

		switch ($return) {
			case 'dom64':
				return "<img src='data:{$query['mime']};base64," . base64_encode($query['img']) . "' class='d-block img-fluid rounded my-4 mx-auto' alt='{$query['description']}' />";
				break;
			case 'base64':
				return "data:{$query['mime']};base64," . base64_encode($query['img']);
				break;
			case 'raw':
				return $query['img'];
				break;
		}

	}

	protected function getVideo($id, $return = 'base64')
	{

		$query = $this->_s->query("SELECT *, COUNT(`id`) AS `total` FROM `images` WHERE `id` = '{$id}'")->fetchArray(1);
		if ($query['total'] < 1) {
			return false;
		}

		switch ($return) {
			case 'domiOs64':
				return "<video class='video-player img-fluid w-100 my-4 mx-auto bg-light' controls playsinline alt='{$query['description']}' src='data:{$query['mime']};base64," . base64_encode($query['img']) . "' type='{$query['mime']}'></video>";
				break;
			case 'dom64':
				return "<video class='video-player img-fluid w-100 my-4 mx-auto bg-light' controls playsinline alt='{$query['description']}'><source src='data:{$query['mime']};base64," . base64_encode($query['img']) . "' type='{$query['mime']}'></video>";
				break;
			case 'base64':
				return "data:{$query['mime']};base64," . base64_encode($query['img']);
				break;
			case 'raw':
				return $query['img'];
				break;
		}

	}

	protected function distance($from, $to, $text = true)
	{

		$earthRad = 6371000;

		$lat = deg2rad($to[0]) - deg2rad($from[0]);
		$lng = deg2rad($to[1]) - deg2rad($from[1]);

		$angle = 2 * asin(sqrt(pow(sin($lat / 2), 2) + cos(deg2rad($from[0])) * cos(deg2rad($to[0])) * pow(sin($lng / 2), 2)));

		$meter = $angle * $earthRad;

		$miles = $meter * 0.000621371;

		if ($text) {
			if ($meter < 1000) {
				return number_format($meter, 0, '', '') . " m (" . number_format($miles, 2, '.', ',') . " Mi)";
			} else {
				return number_format($meter / 1000, 2, ',', '.') . " Km (" . number_format($miles, 2, '.', ',') . " Mi)";
			}
		} else {
			return $meter;
		}

	}

	protected function lang( $lang = null )
	{

		$_l = setLang ( $lang );

		$this->lang = [$_l, strtoupper($_l), "{$_l}-" . strtoupper($_l), "{$_l}_" . strtoupper($_l)];
		// require __DIR__ . "/../lang/{$this->lang[0]}/apartment.php";
		$this->_ = json_decode(file_get_contents(realpath(LNG.$this->lang[0].'/apartment.json')));

	}

	protected function meta()
	{

		if ($this->_log) {
			$select2 = [
				"<link rel='stylesheet' href='{$this->_http}lib/bs/css/select2.min.css' />",
				"<link rel='stylesheet' href='{$this->_http}lib/bs/css/select2-bootstrap-5-theme.min.css' />"
			];
		} else {
			$select2 = ["", ""];
		}

		$this->html[] = "
			<head>
				<title>{$this->data['name']} ({$this->data['ref']}) [[TITLE]] - GrupoQuattro CheckIN</title>
				<meta charset='utf-8' />
				<meta http-equiv='X-UA-Compatible' content='IE=Edge' />
				<meta http-equiv='Content-Type' content='text/html;charset=UTF-8' />
				<meta http-equiv='imagetoolbar' content='no' />
				<meta name='viewport' content='viewport-fit=cover, width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no' />
				<meta name='MobileOptimized' content='width' />
				<meta name='HandheldFriendly' content='true' />
				<meta name='title' content='{$this->data['name']} ({$this->data['ref']})' />
				<meta name='description' content='{$this->data['description'][$this->lang[0]]}' />
				<meta name='keywords' content='' />
				<meta name='author' content='Grupo Quattro' />
				<meta name='owner' content='Grupo Quattro' />
				<meta name='copyright' content='' />
				<meta name='contact' content='biuro@grupoquattro.com' />
				<meta name='robots' content='noindex, nofollow, noarchive' />
				<meta name='lang' content='{$this->lang[0]}' />
				<meta name='language' content='{$this->lang[1]}' />
				<meta name='theme-color' content='#ee8e1f' />
				<meta name='msapplication-navbutton-color' content='#ee8e1f' />
				<meta name='msapplication-tap-highlight' content='no' />
				<meta name='msapplication-TileColor' content='#ee8e1f' />
				<meta name='apple-mobile-web-app-status-bar-style' content='black-translucent' />
				<meta name='apple-mobile-web-app-capable' content='yes' />
				<meta name='format-detection' content='telephone=no,address=no,email=no,date=no,url=no' />
				<meta itemprop='name' content='{$this->data['name']} ({$this->data['ref']})' />
				<meta itemprop='description' content='{$this->data['description'][$this->lang[0]]}' />
				<meta itemprop='image' content='{$this->_http}sharing/" . base64_encode(json_encode(['ref' => $this->data['ref'], 'name' => $this->data['name']])) . "' />
				<meta property='og:title' content='{$this->data['name']} ({$this->data['ref']})' />
				<meta property='og:type' content='article' />
				<meta property='og:locale' content='{$this->lang[3]}' />
				<meta property='og:description' content='{$this->data['description'][$this->lang[0]]}' />
				<meta property='og:site_name' content='Grupo Quattro CB' />
				<meta property='og:url' content='{$this->_http}/{$_GET['ref']}' />
				<meta property='og:image' content='{$this->_http}sharing/" . base64_encode(json_encode(['ref' => $this->data['ref'], 'name' => $this->data['name']])) . "' />
				<link rel='stylesheet' href='{$this->_http}lib/bs/css/bootstrap.min.css' />
				{$select2[0]}
				{$select2[1]}
				<link rel='stylesheet' href='{$this->_http}assets/fa/css/all.min.css' />
				<link rel='stylesheet' href='{$this->_http}lib/map/leaflet.css' />
				<link rel='stylesheet' href='{$this->_http}lib/map/minimap/dist/Control.MiniMap.min.css' />
				<link rel='stylesheet' href='{$this->_http}lib/map/handler/dist/leaflet-gesture-handling.min.css' />
				<style type='text/css'>
					.accordion-button:not(.collapsed) {
						color: #ee8e1f !important;
						background-color: #FDF5EB !important;
					}
					.accordion-button:not(.collapsed)::after {
						background-image: url(\"data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23ee8e1f'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e\") !important;
					}
					.accordion-button:focus,
					.form-control:focus,
					.form-select:focus,
					.select2-container--bootstrap-5.select2-container--focus .select2-selection, .select2-container--bootstrap-5.select2-container--open .select2-selection {
						border-color: #F9D6AE !important;
						box-shadow: 0 0 0 .25rem rgba(130,77,17,.25) !important;
					}
					.select2-container--bootstrap-5 .select2-dropdown {
						border-color: #F9D6AE !important;
					}
					.select2-container--bootstrap-5 .select2-dropdown .select2-results__options .select2-results__option.select2-results__option--selected {
						background-color: #F9D6AE !important;
					}
					.card-infos {
						margin: 1.5rem 0;
					}
					.card-infos:first-child {
						margin-top: 0;
					}
					.card-infos:last-child {
						margin-bottom: 0;
					}
					.divMarker {
						background-color: #99F;
						color: #FF0;
						font-weight: bold;
						font-size: 8px;
						border: 1px solid #00F;
						text-align: center;
						padding: 2px;
						width: auto !important;
						height: auto !important;
					}
				</style>
				<script type='text/javascript' src='{$this->_http}lib/map/leaflet.dist.js'></script>
				<script type='text/javascript' src='{$this->_http}lib/map/minimap/dist/Control.MiniMap.dist.min.js'></script>
				<script type='text/javascript' src='{$this->_http}lib/map/handler/dist/leaflet-gesture-handling.dist.min.js'></script>
				<script type='text/javascript'>
					var _u = '{$this->_http}';
					var _l = '{$this->lang[0]}';
					var map = {};
					var minimap = {};
					var layers = {};
					var jsonData = fetch ( '{$this->_http}lib/mapPolygons.json' ).then ( (response) => response.json () );

					L.Control.Compass = L.Control.extend ( {
						onAdd: (map) => {
							var img = L.DomUtil.create ( 'img' );
							img.src = '{$this->_http}assets/compass.png';
							img.style.width = '80%';
							img.style.height = 'auto';

							return img;
						},
						onRemove: (map) => {}
					} );
					L.control.compass = (opts) => {
						return new L.Control.Compass ( opts );
					};

					L.Control.Button = L.Control.extend ( {
						options: {
							position: 'topleft',
							latlng: null
						},
						initialize: (options) => {
							L.setOptions ( this, options );
						},
						onAdd: (map) => {
							var container = L.DomUtil.create ( 'span' );
							container.style.margin = '0';

							var divG = L.DomUtil.create ( 'div', 'leaflet-bar leaflet-control', container );
							var divA = L.DomUtil.create ( 'div', 'leaflet-bar leaflet-control', container );

							var btnG = L.DomUtil.create ( 'a', '', divG );
							var btnA = L.DomUtil.create ( 'a', '', divA );

							btnG.innerHTML = `<img src='{$this->_http}assets/small_icon.png' style='width:1.25rem;height:auto;' />`;
							btnG.setAttribute ( 'href', 'javascript:void(0)' );
							btnG.setAttribute ( 'role', 'button' );
							btnG.setAttribute ( 'aria-disabled', 'false' );
							btnA.innerHTML = `<i class='fas fa-house-building'></i>`;
							btnA.setAttribute ( 'href', 'javascript:void(0)' );
							btnA.setAttribute ( 'role', 'button' );
							btnA.setAttribute ( 'aria-disabled', 'false' );

							L.DomEvent.addListener ( btnG, 'click', e => {
								map.flyTo ( L.latLng ( 37.91149, -0.73994 ), 18 );
							} );

							L.DomEvent.addListener ( btnA, 'click', e => {
								map.flyTo ( this.options.latlng, 18 );
							} );

							return container;
						},
						onRemove: (map) => {}
					} );
				</script>
			</head>
		";

	}

	protected function header()
	{

		$this->html[] = "
			<section id='top' class='mb-4'>
				<img src='{$this->_http}assets/LOGO_BLACK.png' class='d-block img-fluid rounded mt-4 mx-auto' alt='GC LOGO' style='max-width:75%;' />
			<h1 class='text-center fw-bold my-4'>{$this->data['name']} </h1>


				" . $this->getImg($this->data['imgs']['main'], 'dom64') . "
			</section>
		";

	}

	function location()
	{

		$add = $this->data['address'];
		$qrgps = call_user_func(function () use ($add) {
			if (!empty($add['lat']) && !empty($add['lng'])) {
				return "
					<button type='button' class='btn btn-dark w-100 mt-3' data-bs-toggle='modal' data-bs-target='#qrgps'><i class='fas fa-qrcode fa-fw'></i> [[BTNS.SHOWAPARTMENTQR]]</button>
					<div class='modal fade' id='qrgps' tabindex='-1' aria-hidden='true' aria-labelledby='qrgpsLabel'>
						<div class='modal-dialog modal-dialog-centered'>
							<div class='modal-content'>
								<div class='modal-header'>
									<h1 class='modal-title fs-5 mx-auto' id='qrgpsLabel'>[[LABELS.SCANME]]</h1>
								</div>
								<div class='modal-body'>
									<img src='https://api.grupoquattro.com/?t=qr&m=gps&lat={$add['lat']}&lng={$add['lng']}' class='d-block img-fluid rounded mx-auto' alt='QR GPS' />
								</div>
								<div class='modal-footer'>
									<button type='button' class='btn btn-dark w-100' data-bs-dismiss='modal'>[[BTNS.CLOSE]]</button>
								</div>
							</div>
						</div>
					</div>
				";
			} else {
				return "";
			}
		});

		$fullAddress = "{$add['nr']}, {$add['block']} {$add['stairs']} {$add['floor']}{$add['door']}, {$add['city']} {$add['zip']} {$add['state']}, {$add['country']}";

		$this->html[] = "
			<div class='accordion-item' id='location'>
				<h2 class='accordion-header' id='AccordLocation'>
					<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseLocation' aria-expanded='true' aria-controls='collapseOne'>
						<i class='fas fa-map-location-dot me-3'></i> [[HEADERS.ADRESS]]
					</button>
				</h2>
				<div id='AccordCollapseLocation' class='accordion-collapse collapse' aria-labelledby='AccordLocation' data-bs-parent='#accordion'>
					<div class='accordion-body p-3'>
						<ul class='list-group list-group-horizontal mb-2'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.STREET]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['street']}</li>
						</ul>
						<ul class='list-group list-group-horizontal mb-2'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.NUMBER]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['nr']}</li>
						</ul>
						<ul class='list-group list-group-horizontal mb-2'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.BLOQ]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['block']}</li>
						</ul>
						<ul class='list-group list-group-horizontal mb-2'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.STAIRS]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['stairs']}</li>
						</ul>
						<ul class='list-group list-group-horizontal mb-2'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.FLOOR]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['floor']}</li>
						</ul>
						<ul class='list-group list-group-horizontal mb-2'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.DOOR]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['door']}</li>
						</ul>
						<ul class='list-group list-group-horizontal mb-2'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.CITY]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['city']}</li>
						</ul>
						<ul class='list-group list-group-horizontal mb-2'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.ZIP]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['zip']}</li>
						</ul>
					<!--	<ul class='list-group list-group-horizontal mb-2'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.STATE]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['state']}</li>
						</ul>
						<ul class='list-group list-group-horizontal'>
							<li class='list-group-item col-4 text-truncate'>[[LABELS.COUNTRY]]</li>
							<li class='list-group-item col-8 text-truncate'>{$add['country']}</li>
						</ul> -->
		";

		if (!empty($add['lat']) && !empty($add['lng'])) {
			$this->html[] = "
				<div id='mapLocation' class='w-100 my-4 mx-auto' style='height:60vh;'></div>
				<!-- <img src='https://api.grupoquattro.com/?t=osm&lat={$add['lat']}&lng={$add['lng']}&z=19&w=1024&h=768&z=19&mark=[[{$add['lat']},{$add['lng']}]]&text={$fullAddress}' class='d-block img-fluid rounded my-2 mx-auto' alt='Map' /> -->
			";
		}

		$this->html[] = "<!--<p class='card-text text-center'>{$fullAddress}</p> -->
						" . (!empty($add['lat']) && !empty($add['lng']) ? "<a href='https://www.google.com/maps/dir//{$add['lat']},{$add['lng']}' class='btn btn-dark w-100' target='_blank'><i class='fas fa-map fa-fw'></i> [[BTNS.OPENAPARTMENTMAP]]</a>" : "") . "
						{$qrgps}
					</div>
				</div>
			</div>
		";

		if (!empty($add['lat']) && !empty($add['lng'])) {

			$this->html[] = "
				<script type='text/javascript'>
					layers.Location = {
						'map': {
							'[[MAP.SAT]]': L.tileLayer ( 'https://{s}google.com/vt/lyrs=s&x={x}&y={y}&z={z}', { maxZoom: 20, minZoom: 8, subdomains: ['mt0.','mt1.','mt2.','mt3.'] } ),
							'[[MAP.STREET]]': L.tileLayer ( 'https://tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19, minZoom: 8 } )
						},
						'minimap': {
							'[[MAP.SAT]]': L.tileLayer ( 'https://{s}google.com/vt/lyrs=s&x={x}&y={y}&z={z}', { maxZoom: 20, minZoom: 1, subdomains: ['mt0.','mt1.','mt2.','mt3.'] } ),
							'[[MAP.STREET]]': L.tileLayer ( 'https://tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19, minZoom: 1 } )
						}
					};
					map.Location = L.map ( 'mapLocation', { keyboard: false, gestureHandling: true, gestureHandlingOptions: { duration: 2000, text: { touch: '[[MAP.TOUCH]]', scroll: '[[MAP.SCROLL]]', scrollMac: '[[MAP.SCROLLMAC]]' } } } );
					map.Location.addLayer ( layers.Location.map ['[[MAP.STREET]]'] );
					map.Location.setView ( L.latLng ({$add['lat']},{$add['lng']}), 18 );
					L.control.layers ( layers.Location.map ).addTo ( map.Location );
					L.control.compass ( { position: 'bottomright' } ).addTo ( map.Location );
					new L.Control.Button ( { latlng: L.latLng ({$add['lat']},{$add['lng']}) } ).addTo ( map.Location );
					minimap.Location = new L.Control.MiniMap ( layers.Location.minimap ['[[MAP.SAT]]'], {
						position: 'bottomleft',
						collapsedWidth: 20,
						collapsedHeight: 20,
						zoomLevelOffset: -4,
						toggleDisplay: 1
					} ).addTo ( map.Location );
					jsonData.then ( v => {
						L.polygon ( v ['{$this->data['name']}'] ['polygon'], {
							color: '#FF6400'
						} ).addTo ( map.Location );
						for ( var i in v ['{$this->data['name']}'] ['markers'] ) {
							for ( var j in v ['{$this->data['name']}'] ['markers'] [i] ) {
								switch ( i ) {
									case 'bin':
										L.marker ( L.latLng ( v ['{$this->data['name']}'] ['markers'] [i] [j] ), {
											icon: L.icon ( {
												iconUrl: '{$this->_http}assets/trash-var-flat.png',
												iconSize: [20,20],
												iconAnchor: [10,10]
											} )
										} ).addTo ( map.Location ).setZIndexOffset ( 100 ).bindTooltip ( '[[MAP.TRASH]]' );
										break;
									default:
										L.marker ( L.latLng ( v ['{$this->data['name']}'] ['markers'] [i] [j] ), {
											icon: L.divIcon ( {
												className: 'divMarker',
												html: j,
												iconAnchor: [20,15]
											} )
										} ).addTo ( map.Location ).setZIndexOffset ( 100 ).bindTooltip ( `\${i} \${j}` );
										break;
								}
							}
						}
					} );
					L.marker ( L.latLng (37.91149, -0.73994), { icon: L.icon ( { iconUrl: '{$this->_http}assets/logo-sx.png', iconSize: [45,45], iconAnchor: [22.5,22.5] } ) } ).addTo ( map.Location ).setZIndexOffset ( 101 )
					L.marker ( L.latLng ({$add['lat']},{$add['lng']}), { icon: L.icon ( { iconUrl: '{$this->_http}assets/marker_simple_no_shadow.png', iconSize: [45,45], iconAnchor: [22.5,45] } ) } ).addTo ( map.Location ).setZIndexOffset ( 101 );
					map.Location.on ( 'baselayerchange', e => {
						switch ( e.name ) {
							case '[[MAP.SAT]]':
								minimap.Location.changeLayer ( layers.Location.minimap ['[[MAP.STREET]]'] );
								break;
							case '[[MAP.STREET]]':
								minimap.Location.changeLayer ( layers.Location.minimap ['[[MAP.SAT]]'] );
								break;
						}
					} );
					document.querySelector ( 'button[data-bs-target=\"#AccordCollapseLocation\"]' ).addEventListener ( 'click', e => {
						if ( !e.target.classList.contains ( 'collapsed' ) ) {
							map.Location.invalidateSize ();
							minimap.Location._miniMap.invalidateSize ();
							map.Location.setView ( L.latLng ({$add['lat']},{$add['lng']}), 18 );
						}
					} );
				</script>
			";

		}

	}

	function network()
	{

		if (!empty($this->data['network']['ssid'])) {

			$this->html[] = "
				<div class='accordion-item' id='network'>
					<h2 class='accordion-header' id='AccordNetwork'>
						<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseNetwork' aria-expanded='true' aria-controls='collapseOne'>
							<i class='fas fa-router me-3'></i> [[HEADERS.INTERNET]]
						</button>
					</h2>
					<div id='AccordCollapseNetwork' class='accordion-collapse collapse' aria-labelledby='AccordNetwork' data-bs-parent='#accordion'>
						<div class='accordion-body p-3'>
							<ul class='list-group list-group-horizontal mb-2'>
								<li class='list-group-item col-4 text-truncate'>[[LABELS.SSID]]</li>
								<li class='list-group-item col-8 text-truncate'>{$this->data['network']['ssid']}</li>
							</ul>
							<ul class='list-group list-group-horizontal mb-2'>
								<li class='list-group-item col-4 text-truncate'>[[LABELS.PASSWORD]]</li>
								<li class='list-group-item col-8 text-truncate'>{$this->data['network']['pass']}</li>
							</ul>
							<button type='button' class='btn btn-dark w-100 mt-3' data-bs-toggle='modal' data-bs-target='#qrwifi'><i class='fas fa-qrcode fa-fw'></i> [[BTNS.SHOWQR]]</button>
							<div class='modal fade' id='qrwifi' tabindex='-1' aria-hidden='true' aria-labelledby='qrwifiLabel'>
								<div class='modal-dialog modal-dialog-centered'>
									<div class='modal-content'>
										<div class='modal-header'>
											<h1 class='modal-title fs-5 mx-auto' id='qrwifiLabel'>[[LABELS.SCANME]]</h1>
										</div>
										<div class='modal-body'>
											<img src='https://api.grupoquattro.com/?t=qr&m=wifi&ssid={$this->data['network']['ssid']}&pass={$this->data['network']['pass']}&sec={$this->data['network']['type']}' class='d-block img-fluid rounded mx-auto' alt='WIFI GPS' />
										</div>
										<div class='modal-footer'>
											<button type='button' class='btn btn-dark w-100' data-bs-dismiss='modal'>[[BTNS.CLOSE]]</button>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			";

		}

	}

	function conditions()
	{

		$conditions = [];

		$conditions[] = "<ul class='list-group list-group-flush'>";
		foreach (translate('COND',null,'apartment.json',true) as $v) {

			$conditions[] = "<li class='list-group-item'>{$v}</li>";

		}
		$conditions[] = "</ul>";

		$conditions[] = "<ul class='list-group list-group-flush'>";
		foreach ($this->data['conditions'][$this->lang[0]] as $v) {

			$conditions[] = "<li class='list-group-item'>{$v}</li>";

		}
		$conditions[] = "</ul>";

		$this->html[] = "
			<div class='accordion-item' id='conditions'>
				<h2 class='accordion-header' id='AccordConditions'>
					<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseConditions' aria-expanded='true' aria-controls='collapseOne'>
						<i class='fas fa-file-signature me-3'></i> [[HEADERS.CONDITIONS]]
					</button>
				</h2>
				<div id='AccordCollapseConditions' class='accordion-collapse collapse' aria-labelledby='AccordConditions' data-bs-parent='#accordion'>
					<div class='accordion-body p-0'>
						" . implode("", $conditions) . "
					</div>
				</div>
			</div>
		";

	}

	function keycollect()
	{

		$keycollect = [];

		$keycollect[] = "<ul class='list-group list-group-flush'>";
		$keycollect[] = "
			<li class='list-group-item'>
				[[KEYCOL.0]]
				<div id='mapKeyCollect' class='w-100 my-4 mx-auto' style='height:60vh;'></div>
				<!-- <img src='https://api.grupoquattro.com/?t=osm&lat=37.911429&lng=-0.73981&z=19&w=1024&h=768&z=19&mark=[[37.911429,-0.73981]]&text=C/ Mar 5, Local 15, Orihuela Costa 03189 Alicante' class='d-block img-fluid rounded my-4 mx-auto' alt='Grupo Quattro CB' /> -->
				<a href='https://www.google.com/maps/dir//37.91149, -0.73994' class='btn btn-dark w-100' target='_blank'><i class='fas fa-map fa-fw'></i> [[BTNS.OPENOFFICEMAP]]</a>
				<button type='button' class='btn btn-dark w-100 mt-3' data-bs-toggle='modal' data-bs-target='#gqgpsqr'><i class='fas fa-qrcode fa-fw'></i> [[BTNS.SHOWOFFICEQR]]</button>
				<div class='modal fade' id='gqgpsqr' tabindex='-1' aria-hidden='true' aria-labelledby='gqgpsqrLabel'>
					<div class='modal-dialog modal-dialog-centered'>
						<div class='modal-content'>
							<div class='modal-header'>
								<h1 class='modal-title fs-5 mx-auto' id='gqgpsqrLabel'>[[LABELS.SCANME]]</h1>
							</div>
							<div class='modal-body'>
								<img src='https://api.grupoquattro.com/?t=qr&m=gps&lat=37.911429&lng=-0.73981' class='d-block img-fluid rounded mx-auto' alt='OFFICE QR GPS' />
							</div>
							<div class='modal-footer'>
								<button type='button' class='btn btn-dark w-100' data-bs-dismiss='modal'>[[BTNS.CLOSE]]</button>
							</div>
						</div>
					</div>
				</div>
				" . $this->getImg(1, 'dom64') . "
			</li>
		";

		$showBox = false;

		if (isset($_GET['box']) || $this->data['box'] > 0) {
			if (isset($_GET['box'])) {
				$this->data['box'] = $_GET['box'];
			}
			$showBox = true;
			$check = $this->_s->query("SELECT COUNT(*) AS `total` FROM `boxes` WHERE `id` = '{$this->data['box']}' AND `deleted` = '0'")->fetchArray(1);
			if ($check['total'] > 0) {

				$check = $this->_s->query("SELECT * FROM `boxes` WHERE `id` = '{$this->data['box']}' AND `deleted` = '0'")->fetchArray(1);
				$check['description'] = json_decode($check['description'], 1);

				$keycollect[] = "
					<li class='list-group-item'>
						[[KEYCOL.1]]<br/><br/>
				";

				$keycollect[] = sprintf(translate('FORMAT.BOX',null,'apartment.json'), isset($check['description'][$this->lang[0]]) ? $check['description'][$this->lang[0]] : "", $check['code']) . '<br/>';
				$keycollect[] = $this->getImg($check['img'], 'dom64');

				$keycollect[] = "</li>";

			}
		}

		$keycollect[] = "
			<li class='list-group-item'>
				[[KEYCOL.2]]
			</li>
		";

		if ($this->data['collect_key'][$this->lang[0]] != '') {
			$keycollect[] = $this->data['collect_key'][$this->lang[0]];
		}
		$keycollect[] = "</ul>";

		$keycollect = implode($keycollect);

		$this->html[] = "
			<div class='accordion-item' id='keycollect'>
				<h2 class='accordion-header' id='AccordKeycollect'>
					<button class='accordion-button" . (!$showBox ? " collapsed" : "") . "' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseKeycollect' aria-expanded='true' aria-controls='collapseOne'>
						<span class='fa-stack fa-fw align-middle me-2' style='font-size:0.8rem !important'><i class='fas fa-hand-holding fa-stack-2x'></i><i class='fas fa-key-skeleton-left-right fa-stack-1x'></i></span><span class='align-middle fs-4'>[[HEADERS.KEYPICKUP]]</span>
					</button>
				</h2>
				<div id='AccordCollapseKeycollect' class='accordion-collapse collapse" . ($showBox ? " show" : "") . "' aria-labelledby='AccordKeycollect' data-bs-parent='#accordion'>
					<div class='accordion-body p-0'>
						{$keycollect}
					</div>
				</div>
			</div>
		";

		$this->html[] = "
			<script type='text/javascript'>
				layers.keyCollect = {
					'map': {
						'[[MAP.SAT]]': L.tileLayer ( 'https://{s}google.com/vt/lyrs=s&x={x}&y={y}&z={z}', { maxZoom: 20, minZoom: 8, subdomains: ['mt0.','mt1.','mt2.','mt3.'] } ),
						'[[MAP.STREET]]': L.tileLayer ( 'https://tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19, minZoom: 8 } )
					},
					'minimap': {
						'[[MAP.SAT]]': L.tileLayer ( 'https://{s}google.com/vt/lyrs=s&x={x}&y={y}&z={z}', { maxZoom: 20, minZoom: 1, subdomains: ['mt0.','mt1.','mt2.','mt3.'] } ),
						'[[MAP.STREET]]': L.tileLayer ( 'https://tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19, minZoom: 1 } )
					}
				};
				map.keyCollect = L.map ( 'mapKeyCollect', { keyboard: false, gestureHandling: true, gestureHandlingOptions: { duration: 2000, text: { touch: '[[MAP.TOUCH]]', scroll: '[[MAP.SCROLL]]', scrollMac: '[[MAP.SCROLLMAC]]' } } } );
				map.keyCollect.addLayer ( layers.keyCollect.map ['[[MAP.STREET]]'] );
				map.keyCollect.setView ( L.latLng (37.91149, -0.73994), 18 );
				L.control.layers ( layers.keyCollect.map ).addTo ( map.keyCollect );
				minimap.keyCollect = new L.Control.MiniMap ( layers.keyCollect.minimap ['[[MAP.SAT]]'], {
					position: 'bottomleft',
					collapsedWidth: 20,
					collapsedHeight: 20,
					zoomLevelOffset: -4,
					toggleDisplay: 1
				} ).addTo ( map.keyCollect );
				L.marker ( L.latLng (37.91149, -0.73994), { icon: L.icon ( { iconUrl: '{$this->_http}assets/logo-sx.png', iconSize: [45,45], iconAnchor: [22.5,22.5] } ) } ).addTo ( map.keyCollect )
				.bindPopup ( '<img src=\"data:image/jpeg;base64," . base64_encode($this->getImg(1, 'raw')) . "\" style=\"max-width:250px;height:auto;\" />' );
				map.keyCollect.on ( 'baselayerchange', e => {
					switch ( e.name ) {
						case '[[MAP.SAT]]':
							minimap.keyCollect.changeLayer ( layers.keyCollect.minimap ['[[MAP.STREET]]'] );
							break;
						case '[[MAP.STREET]]':
							minimap.keyCollect.changeLayer ( layers.keyCollect.minimap ['[[MAP.SAT]]'] );
							break;
					}
				} );
				document.querySelector ( 'button[data-bs-target=\"#AccordCollapseKeycollect\"]' ).addEventListener ( 'click', e => {
					if ( !e.target.classList.contains ( 'collapsed' ) ) {
						map.keyCollect.invalidateSize ();
						minimap.keyCollect._miniMap.invalidateSize ();
						map.keyCollect.setView ( L.latLng (37.91149, -0.73994), 18 );
					}
				} );
			</script>
		";

	}

	function apartment()
	{

		$this->html[] = "
			<div class='accordion-item' id='apartment'>
				<h2 class='accordion-header' id='AccordApartment'>
					<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseApartment' aria-expanded='true' aria-controls='collapseOne'>
						<i class='fas fa-house-building me-3'></i> [[HEADERS.APARTAMENT]]
					</button>
				</h2>
				<div id='AccordCollapseApartment' class='accordion-collapse collapse' aria-labelledby='AccordApartment' data-bs-parent='#accordion'>
					<div class='accordion-body p-3'>
						" . $this->getImg($this->data['imgs']['map'], 'dom64') . "
						" . $this->getImg($this->data['imgs']['entry'], 'dom64') . "
						" . $this->getImg($this->data['imgs']['apartment'], 'dom64') . "
						{$this->data['to_apartment'][$this->lang[0]]}
					</div>
				</div>
			</div>
		";

	}

	function keyleft()
	{

		$this->html[] = "
			<div class='accordion-item' id='keyleft'>
				<h2 class='accordion-header' id='AccordKeyleft'>
					<button class='accordion-button collapsed' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseKeyleft' aria-expanded='true' aria-controls='collapseOne'>
						<span class='fa-stack fa-flip-both fa-fw align-middle me-2' style='font-size:0.8rem !important'><i class='fas fa-hand-holding fa-stack-2x'></i><i class='fas fa-key-skeleton-left-right fa-stack-1x'></i></span> <span class='align-top fs-4'>[[HEADERS.KEYDEPOSIT]]</span>
					</button>
				</h2>
				<div id='AccordCollapseKeyleft' class='accordion-collapse collapse' aria-labelledby='AccordKeyleft' data-bs-parent='#accordion'>
					<div class='accordion-body p-0'>
						<ul class='list-group list-group-flush'>
							<li class='list-group-item'>[[KEYLEFT.0]]
								" . $this->getImg(2, 'dom64') . "
							</li>
							<li class='list-group-item'>[[KEYLEFT.1]]</li>
							<li class='list-group-item'>[[KEYLEFT.2]]</li>
						</ul>
					</div>
				</div>
			</div>
		";

	}

	function garage()
	{

		if (
			$this->data['garage'][$this->lang[0]] != '' ||
			$this->data['imgs']['garage'] != 0 ||
			$this->data['garage']['data']['gate'] != '' ||
			$this->data['garage']['data']['floor'] != '' ||
			$this->data['garage']['data']['nr'] != ''
		) {

			$this->html[] = "
				<div class='accordion-item' id='garage'>
					<h2 class='accordion-header' id='AccordGarage'>
						<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseGarage' aria-expanded='true' aria-controls='collapseOne'>
							<i class='fas fa-car-garage me-3'></i> [[HEADERS.GARAGE]]
						</button>
					</h2>
					<div id='AccordCollapseGarage' class='accordion-collapse collapse' aria-labelledby='AccordGarage' data-bs-parent='#accordion'>
						<div class='accordion-body p-3'>
							<ul class='list-group list-group-horizontal mb-2'>
								<li class='list-group-item col-4 text-truncate'>[[LABELS.DOOR]]</li>
								<li class='list-group-item col-8 text-truncate'>{$this->data['garage']['data']['gate']}</li>
							</ul>
							<ul class='list-group list-group-horizontal mb-2'>
								<li class='list-group-item col-4 text-truncate'>[[LABELS.LEVEL]]</li>
								<li class='list-group-item col-8 text-truncate'>{$this->data['garage']['data']['floor']}</li>
							</ul>
							<ul class='list-group list-group-horizontal mb-2'>
								<li class='list-group-item col-4 text-truncate'>[[LABELS.PLACE]]</li>
								<li class='list-group-item col-8 text-truncate'>{$this->data['garage']['data']['nr']}</li>
							</ul>
							" . $this->getImg($this->data['imgs']['garage'], 'dom64') . "
							{$this->data['garage'][$this->lang[0]]}
						</div>
					</div>
				</div>
			";

		}

	}

	function beaches()
	{

		$total = $this->_s->query("SELECT COUNT(*) AS `total` FROM `interest` WHERE `type` = '0' AND `active` = '1' AND `deleted` = '0'")->fetchArray(1);

		if ($total['total'] > 0) {

			$ghost = [];
			$collect = [];
			$beaches = [];

			$check = $this->_s->query("SELECT * FROM `interest` WHERE `type` = '0' AND `active` = '1' AND `deleted` = '0'");

			while ($r = $check->fetchArray(1)) {

				$title = json_decode($r['title'], 1);
				$address = json_decode($r['address'], 1);
				$contact = json_decode($r['contact'], 1);

				$fullAddr = "{$address['street']} {$address['nr']}, {$address['block']} {$address['stairs']}, {$address['floor']} {$address['door']}, {$address['zip']} {$address['city']}, {$address['country']}";
				$collect[] = $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']], false);

				$ghost[] = "
					<div class='card card-infos'>
						<div class='card-body'>
							<h5 class='card-title'>{$title[$this->lang[0]]} <small class='text-muted'>([[INTEREST.{$r['type']}]])</small></h5>
							<small class='text-muted'>
								" . (!empty($address['lat']) && !empty($address['lng']) && !empty($this->data['address']['lat']) && !empty($this->data['address']['lng']) ? $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']]) : "") . "
								- {$fullAddr}
							</small>
							" . (!empty($address['lat']) && !empty($address['lng']) ? "<a href='https://www.google.com/maps/dir//{$address['lat']},{$address['lng']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-map fa-fw'></i> [[BTNS.OPENMAP]]</a>" : "") . "
							" . (!empty($contact['phone']) ? "<a href='tel:{$contact['phone']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-phone-rotary fa-fw'></i> [[BTNS.PHONE]]</a>" : "") . "
							" . (!empty($contact['whatsapp']) ? "<a href='https://wa.me/{$contact['whatsapp']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fab fa-whatsapp fa-fw'></i> [[BTNS.WHATSAPP]]</a>" : "") . "
							" . (!empty($contact['email']) ? "<a href='mailto:{$contact['email']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-envelopes fa-fw'></i> [[BTNS.EMAIL]]</a>" : "") . "
							" . (!empty($contact['web']) ? "<a href='{$contact['web']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-browser fa-fw'></i> [[BTNS.WEBSITE]]</a>" : "") . "
						</div>
					</div>
				";

			}

			asort($collect);

			foreach ($collect as $k => $v) {
				$beaches[] = $ghost[$k];
			}

			$this->html[] = "
				<div class='accordion-item' id='beaches'>
					<h2 class='accordion-header' id='AccordBeaches'>
						<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseBeaches' aria-expanded='true' aria-controls='collapseOne'>
							<i class='fas fa-umbrella-beach me-3'></i> [[HEADERS.BEACHES]]
						</button>
					</h2>
					<div id='AccordCollapseBeaches' class='accordion-collapse collapse' aria-labelledby='AccordBeaches' data-bs-parent='#accordion'>
						<p class='w-100 text-center text-muted p-3'>[[INFO.2]]</p>
						<div class='accordion-body p-3'>
							" . implode($beaches) . "
						</div>
					</div>
				</div>
			";

		}

	}

	function restaurants()
	{

		$total = $this->_s->query("SELECT COUNT(*) AS `total` FROM `interest` WHERE `type` = '2' AND `active` = '1' AND `deleted` = '0'")->fetchArray(1);

		if ($total['total'] > 0) {

			$ghost = [];
			$collect = [];
			$restaurants = [];

			$check = $this->_s->query("SELECT * FROM `interest` WHERE `type` = '2' AND `active` = '1' AND `deleted` = '0'");

			while ($r = $check->fetchArray(1)) {

				$title = json_decode($r['title'], 1);
				$address = json_decode($r['address'], 1);
				$contact = json_decode($r['contact'], 1);

				$fullAddr = "{$address['street']} {$address['nr']}, {$address['block']} {$address['stairs']}, {$address['floor']} {$address['door']}, {$address['zip']} {$address['city']}, {$address['country']}";
				$collect[] = $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']], false);

				$ghost[] = "
					<div class='card card-infos'>
						<div class='card-body'>
							<h5 class='card-title'>{$title[$this->lang[0]]} <small class='text-muted'>([[INTEREST.{$r['type']}]])</small></h5>
							<small class='text-muted'>
								" . (!empty($address['lat']) && !empty($address['lng']) && !empty($this->data['address']['lat']) && !empty($this->data['address']['lng']) ? $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']]) : "") . "
								- {$fullAddr}
							</small>
							" . (!empty($address['lat']) && !empty($address['lng']) ? "<a href='https://www.google.com/maps/dir//{$address['lat']},{$address['lng']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-map fa-fw'></i> [[BTNS.OPENMAP]]</a>" : "") . "
							" . (!empty($contact['phone']) ? "<a href='tel:{$contact['phone']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-phone-rotary fa-fw'></i> [[BTNS.PHONE]]</a>" : "") . "
							" . (!empty($contact['whatsapp']) ? "<a href='https://wa.me/{$contact['whatsapp']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fab fa-whatsapp fa-fw'></i> [[BTNS.WHATSAPP]]</a>" : "") . "
							" . (!empty($contact['email']) ? "<a href='mailto:{$contact['email']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-envelopes fa-fw'></i> [[BTNS.EMAIL]]</a>" : "") . "
							" . (!empty($contact['web']) ? "<a href='{$contact['web']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-browser fa-fw'></i> [[BTNS.WEBSITE]]</a>" : "") . "
						</div>
					</div>
				";

			}

			asort($collect);

			foreach ($collect as $k => $v) {
				$restaurants[] = $ghost[$k];
			}

			$this->html[] = "
				<div class='accordion-item' id='restaurants'>
					<h2 class='accordion-header' id='AccordRestaurants'>
						<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseRestaurants' aria-expanded='true' aria-controls='collapseOne'>
							<i class='fas fa-fork-knife me-3'></i> [[HEADERS.RESTAURANTS]]
						</button>
					</h2>
					<div id='AccordCollapseRestaurants' class='accordion-collapse collapse' aria-labelledby='AccordRestaurants' data-bs-parent='#accordion'>
						<p class='w-100 text-center text-muted p-3'>[[INFO.2]]</p>
						<div class='accordion-body p-3'>
							" . implode($restaurants) . "
						</div>
					</div>
				</div>
			";

		}

	}

	function shops()
	{

		$total = $this->_s->query("SELECT COUNT(*) AS `total` FROM `interest` WHERE `type` = '1' AND `active` = '1' AND `deleted` = '0'")->fetchArray(1);

		if ($total['total'] > 0) {

			$ghost = [];
			$collect = [];
			$shops = [];

			$check = $this->_s->query("SELECT * FROM `interest` WHERE `type` = '1' AND `active` = '1' AND `deleted` = '0'");

			while ($r = $check->fetchArray(1)) {

				$title = json_decode($r['title'], 1);
				$address = json_decode($r['address'], 1);
				$contact = json_decode($r['contact'], 1);

				$fullAddr = "{$address['street']} {$address['nr']}, {$address['block']} {$address['stairs']}, {$address['floor']} {$address['door']}, {$address['zip']} {$address['city']}, {$address['country']}";
				$collect[] = $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']], false);

				$ghost[] = "
					<div class='card card-infos'>
						<div class='card-body'>
							<h5 class='card-title'>{$title[$this->lang[0]]} <small class='text-muted'>([[INTEREST.{$r['type']}]])</small></h5>
							<small class='text-muted'>
								" . (!empty($address['lat']) && !empty($address['lng']) && !empty($this->data['address']['lat']) && !empty($this->data['address']['lng']) ? $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']]) : "") . "
								- {$fullAddr}
							</small>
							" . (!empty($address['lat']) && !empty($address['lng']) ? "<a href='https://www.google.com/maps/dir//{$address['lat']},{$address['lng']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-map fa-fw'></i> [[BTNS.OPENMAP]]</a>" : "") . "
							" . (!empty($contact['phone']) ? "<a href='tel:{$contact['phone']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-phone-rotary fa-fw'></i> [[BTNS.PHONE]]</a>" : "") . "
							" . (!empty($contact['whatsapp']) ? "<a href='https://wa.me/{$contact['whatsapp']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fab fa-whatsapp fa-fw'></i> [[BTNS.WHATSAPP]]</a>" : "") . "
							" . (!empty($contact['email']) ? "<a href='mailto:{$contact['email']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-envelopes fa-fw'></i> [[BTNS.EMAIL]]</a>" : "") . "
							" . (!empty($contact['web']) ? "<a href='{$contact['web']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-browser fa-fw'></i> [[BTNS.WEBSITE]]</a>" : "") . "
						</div>
					</div>
				";

			}

			asort($collect);

			foreach ($collect as $k => $v) {
				$shops[] = $ghost[$k];
			}

			$this->html[] = "
				<div class='accordion-item' id='shops'>
					<h2 class='accordion-header' id='AccordShops'>
						<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseShops' aria-expanded='true' aria-controls='collapseOne'>
							<i class='fas fa-bags-shopping me-3'></i> [[HEADERS.SHOPS]]
						</button>
					</h2>
					<div id='AccordCollapseShops' class='accordion-collapse collapse' aria-labelledby='AccordShops' data-bs-parent='#accordion'>
						<p class='w-100 text-center text-muted p-3'>[[INFO.2]]</p>
						<div class='accordion-body p-3'>
							" . implode($shops) . "
						</div>
					</div>
				</div>
			";

		}

	}

	function interests()
	{

		$total = $this->_s->query("SELECT COUNT(*) AS `total` FROM `interest` WHERE (`type` != '0' AND `type` != '1' AND `type` != '2' AND `type` != '8') AND `active` = '1' AND `deleted` = '0'")->fetchArray(1);

		if ($total['total'] > 0) {

			$ghost = [];
			$collect = [];
			$other = [];

			$check = $this->_s->query("SELECT * FROM `interest` WHERE (`type` != '0' AND `type` != '1' AND `type` != '2' AND `type` != '8') AND `active` = '1' AND `deleted` = '0'");

			while ($r = $check->fetchArray(1)) {

				$title = json_decode($r['title'], 1);
				$address = json_decode($r['address'], 1);
				$contact = json_decode($r['contact'], 1);

				$fullAddr = "{$address['street']} {$address['nr']}, {$address['block']} {$address['stairs']}, {$address['floor']} {$address['door']}, {$address['zip']} {$address['city']}, {$address['country']}";
				$collect[] = $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']], false);

				$ghost[] = "
					<div class='card card-infos'>
						<div class='card-body'>
							<h5 class='card-title'>{$title[$this->lang[0]]} <small class='text-muted'>([[INTEREST.{$r['type']}]])</small></h5>
							<small class='text-muted'>
								" . (!empty($address['lat']) && !empty($address['lng']) && !empty($this->data['address']['lat']) && !empty($this->data['address']['lng']) ? $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']]) : "") . "
								- {$fullAddr}
							</small>
							" . (!empty($address['lat']) && !empty($address['lng']) ? "<a href='https://www.google.com/maps/dir//{$address['lat']},{$address['lng']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-map fa-fw'></i> [[BTNS.OPENMAP]]</a>" : "") . "
							" . (!empty($contact['phone']) ? "<a href='tel:{$contact['phone']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-phone-rotary fa-fw'></i> [[BTNS.PHONE]]</a>" : "") . "
							" . (!empty($contact['whatsapp']) ? "<a href='https://wa.me/{$contact['whatsapp']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fab fa-whatsapp fa-fw'></i> [[BTNS.WHATSAPP]]</a>" : "") . "
							" . (!empty($contact['email']) ? "<a href='mailto:{$contact['email']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-envelopes fa-fw'></i> [[BTNS.EMAIL]]</a>" : "") . "
							" . (!empty($contact['web']) ? "<a href='{$contact['web']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-browser fa-fw'></i> [[BTNS.WEBSITE]]</a>" : "") . "
						</div>
					</div>
				";

			}

			asort($collect);

			foreach ($collect as $k => $v) {
				$other[] = $ghost[$k];
			}

			$this->html[] = "
				<div class='accordion-item' id='interests'>
					<h2 class='accordion-header' id='AccordInterest'>
						<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseInterests' aria-expanded='true' aria-controls='collapseOne'>
							<i class='fas fa-landmark me-3'></i> [[HEADERS.TURISM]]
						</button>
					</h2>
					<div id='AccordCollapseInterests' class='accordion-collapse collapse' aria-labelledby='AccordInterests' data-bs-parent='#accordion'>
						<p class='w-100 text-center text-muted p-3'>[[INFO.2]]</p>
						<div class='accordion-body p-3'>
							" . implode($other) . "
						</div>
					</div>
				</div>
			";

		}

	}

	function publicServices()
	{

		$total = $this->_s->query("SELECT COUNT(*) AS `total` FROM `interest` WHERE `type` = '8' AND `active` = '1' AND `deleted` = '0'")->fetchArray(1);

		if ($total['total'] > 0) {

			$ghost = [];
			$collect = [];
			$services = [];

			$check = $this->_s->query("SELECT * FROM `interest` WHERE `type` = '8' AND `active` = '1' AND `deleted` = '0'");

			while ($r = $check->fetchArray(1)) {

				$title = json_decode($r['title'], 1);
				$address = json_decode($r['address'], 1);
				$contact = json_decode($r['contact'], 1);

				$fullAddr = "{$address['street']} {$address['nr']}, {$address['block']} {$address['stairs']}, {$address['floor']} {$address['door']}, {$address['zip']} {$address['city']}, {$address['country']}";
				$collect[] = $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']], false);

				$ghost[] = "
					<div class='card card-infos'>
						<div class='card-body'>
							<h5 class='card-title'>{$title[$this->lang[0]]} <small class='text-muted'>([[INTEREST.{$r['type']}]])</small></h5>
							<small class='text-muted'>
								" . (!empty($address['lat']) && !empty($address['lng']) && !empty($this->data['address']['lat']) && !empty($this->data['address']['lng']) ? $this->distance([$this->data['address']['lat'], $this->data['address']['lng']], [$address['lat'], $address['lng']]) : "") . "
								- {$fullAddr}
							</small>
							" . (!empty($address['lat']) && !empty($address['lng']) ? "<a href='https://www.google.com/maps/dir//{$address['lat']},{$address['lng']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-map fa-fw'></i> [[BTNS.OPENMAP]]</a>" : "") . "
							" . (!empty($contact['phone']) ? "<a href='tel:{$contact['phone']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-phone-rotary fa-fw'></i> [[BTNS.PHONE]]</a>" : "") . "
							" . (!empty($contact['whatsapp']) ? "<a href='https://wa.me/{$contact['whatsapp']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fab fa-whatsapp fa-fw'></i> [[BTNS.WHATSAPP]]</a>" : "") . "
							" . (!empty($contact['email']) ? "<a href='mailto:{$contact['email']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-envelopes fa-fw'></i> [[BTNS.EMAIL]]</a>" : "") . "
							" . (!empty($contact['web']) ? "<a href='{$contact['web']}' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-browser fa-fw'></i> [[BTNS.WEBSITE]]</a>" : "") . "
						</div>
					</div>
				";

			}

			asort($collect);

			foreach ($collect as $k => $v) {
				$services[] = $ghost[$k];
			}

			$this->html[] = "
				<div class='accordion-item' id='services'>
					<h2 class='accordion-header' id='AccordServices'>
						<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseServices' aria-expanded='true' aria-controls='collapseOne'>
							<i class='fas fa-hand-holding-medical me-3'></i> [[HEADERS.SERVICES]]
						</button>
					</h2>
					<div id='AccordCollapseServices' class='accordion-collapse collapse' aria-labelledby='AccordServices' data-bs-parent='#accordion'>
						<p class='w-100 text-center text-muted p-3'>[[INFO.2]]</p>
						<div class='accordion-body p-3'>
							" . implode($services) . "
						</div>
					</div>
				</div>
			";

		}

	}

	function info()
	{

		$wa = translate('FORMAT.WHATSAPP',null,'apartment.json');

		$this->html[] = "
			<div class='accordion-item' id='info'>
				<h2 class='accordion-header' id='AccordInfo'>
					<button class='accordion-button collapsed fs-4' type='button' data-bs-toggle='collapse' data-bs-target='#AccordCollapseInfo' aria-expanded='true' aria-controls='collapseOne'>
						<i class='fas fa-circle-info me-3'></i> [[HEADERS.INFORMATION]]
					</button>
				</h2>
				<div id='AccordCollapseInfo' class='accordion-collapse collapse' aria-labelledby='AccordInfo' data-bs-parent='#accordion'>
					<div class='accordion-body p-3'>
						<ul class='list-group list-group-flush'>
							<li class='list-group-item'>
								[[INFO.0]]
								<a href='https://www.google.com/maps/dir//37.911429,-0.73981' class='btn btn-dark w-100 mt-3' target='_blank'><i class='fas fa-map fa-fw'></i> [[BTNS.OPENOFFICEMAP]]</a>
							</li>
							<li class='list-group-item'>[[INFO.1]]</li>
							<li class='list-group-item'>
								<center class='fw-bold fs-2'>+34 607 756 369</center>
								<a href='tel:0034607756369' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-phone-rotary fa-fw'></i> [[BTNS.PHONE]]</a>
								<a href='" . sprintf(translate('FORMAT.WA',null,'apartment.json'),'34607756369',sprintf($wa, $_GET['ref'])) . "' class='btn btn-dark w-100 my-2' target='_blank'><i class='fab fa-whatsapp fa-fw'></i> [[BTNS.WHATSAPP]]</a>
								<a href='mailto:biuro@grupoquattro.com' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-envelopes fa-fw'></i> [[BTNS.EMAIL]]</a>
							</li>
							<li class='list-group-item'>
								<center class='fw-bold fs-2'>+34 661 654 432</center>
								<a href='tel:0034661654432' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-phone-rotary fa-fw'></i> [[BTNS.PHONE]]</a>
								<a href='" . sprintf(translate('FORMAT.WA',null,'apartment.json'),'34661654432',sprintf($wa, $_GET['ref'])) . "' class='btn btn-dark w-100 my-2' target='_blank'><i class='fab fa-whatsapp fa-fw'></i> [[BTNS.WHATSAPP]]</a>
								<a href='mailto:mateo@grupoquattro.com' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-envelopes fa-fw'></i> [[BTNS.EMAIL]]</a>
							</li>
							<li class='list-group-item bg-warning rounded'>
								<center class='fw-bold fs-2'>+34 600 336 133</center>
								[[INFO.3]]
								<a href='tel:0034600336133' class='btn btn-dark w-100 my-2' target='_blank'><i class='fas fa-phone-rotary fa-fw'></i> [[BTNS.PHONE]]</a>
								<a href='" . sprintf(translate('FORMAT.WA',null,'apartment.json'),'34600336133',sprintf($wa, $_GET['ref'])) . "' class='btn btn-dark w-100 my-2' target='_blank'><i class='fab fa-whatsapp fa-fw'></i> [[BTNS.WHATSAPP]]</a>
							</li>
						</ul>
					</div>
				</div>
			</div>
		";

	}

	function register()
	{

		if ($this->_log) {

			$html = "
				<div class='modal fade' id='tenantCheckin' tabindex='-1' aria-hidden='true' aria-labeledby='tenantCheckinLabel' data-bs-backdrop='static' data-bs-keyboard='false'>
					<div class='modal-dialog modal-fullscreen-md-down modal-dialog-centered modal-dialog-scrollable'>
						<div class='modal-content'>
							<div class='modal-header'><span class='h4 w-100 text-center'>[[FORM.TITLE]]</span></div>
							<div class='modal-body pt-0'>
								<div class='container sticky-top py-2' style='background:white;'>
									<p style='text-align: justify;'>[[FORM.SUBTITLE]]</p>
									<button type='button' class='btn btn-dark w-100' data-bs-toggle='modal' data-bs-target='#politycsModal'>[[FORM.POLITICS]]</button>
								</div>
								<form id='newTentants' class='container needs-validation' autocomplete='off' autocapitalize='off' novalidate>
									<input type='hidden' name='t' value='checkin' />
									<input type='hidden' name='ref' value='{$_GET['ref']}' />
									<div class='form-floating mt-3'>
										<input type='text' class='form-control' id='te-booking' name='te-booking' tabindex='0' placeholder='[[FORM.RESERVATION]]' minlength='12' maxlength='12' onkeyup='checkReservation(event)' required />
										<label for='te-booking'>[[FORM.RESERVATION]]</label>
										<div class='invalid-feedback'>
											[[FORM.INVALIDRESERVATION]]
										</div>
									</div>
									<div class='form-floating mt-5'>
										<input type='text' class='form-control' id='te-email' name='te-email' tabindex='0' placeholder='[[FORM.EMAIL]]' onkeyup='checkEmail(event)' />
										<label for='te-email'>[[FORM.EMAIL]]</label>
									</div>
									<div class='input-group mt-3'>
										<select class='form-select col-4' id='te-coco' name='te-coco' placeholder='[[FORM.COUNTRYCODE]]'></select>
										<div class='form-floating col-8'>
											<input type='text' class='form-control' id='te-phone' name='te-phone' tabindex='0' placeholder='[[FORM.PHONE]]' minlength='6' onkeydown='return onlyNumb(event)' required />
											<label for='te-phone'>[[FORM.PHONE]]</label>
										</div>
									</div>
									<div class='form-floating mt-3'>
										<input type='text' class='form-control' id='te-address' name='te-address' tabindex='0' placeholder='[[FORM.ADRESS]]' />
										<label for='te-address'>[[FORM.ADRESS]]</label>
									</div>

									<div class='mt-5 w-100 text-center'>[[FORM.ADDTENANT]]</div>
									<div class='w-100 my-2 pb-2 border-bottom nTenant'>
										<div class='input-group'>
											<div class='form-floating col-6'>
												<input type='text' class='form-control' id='te-name[0]' name='te-name[0]' tabindex='0' minlength='3' placeholder='[[FORM.NAME]]' required />
												<label for='te-name[0]'>[[FORM.NAME]]</label>
											</div>
											<div class='form-floating col-6'>
												<input type='text' class='form-control' id='te-surname[0]' name='te-surname[0]' tabindex='0' minlength='3' placeholder='[[FORM.SURNAME]]' required />
												<label for='te-surname[0]'>[[FORM.SURNAME]]</label>
											</div>
										</div>
										<div class='form-floating mt-2'>
											<input type='text' class='form-control' id='te-doc[0]' name='te-doc[0]' tabindex='0' minlength='6' placeholder='[[FORM.DOC]]' required />
											<label for='te-doc[0]'>[[FORM.DOC]]</label>
										</div>
									</div>
									<button type='button' class='btn btn-light w-100 mt-1 addTenant'>[[FORM.ADD]]</button>
									<input type='submit' class='d-none' id='tenantSubmit' />
								</form>
							</div>
							<div class='modal-footer'>
								<label for='tenantSubmit' class='btn btn-dark w-100'>[[FORM.REGISTER]]</label>
							</div>
						</div>
					</div>
				</div>
			";

			$pol = translate('POL',null,'apartment.json',true);

			$html .= "
				<div class='modal fade' id='politycsModal' tabindex='-1' aria-hidden='true' aria-labeledby='politycsModalLabel' data-bs-backdrop='static' data-bs-keyboard='false'>
					<div class='modal-dialog modal-fullscreen-md-down modal-dialog-centered modal-dialog-scrollable'>
						<div class='modal-content'>
							<div class='modal-header'><span class='w-100 text-center fw-bold'>{$pol[0]}</span></div>
							<div class='modal-body'>
								<p class='text-center'>{$pol[1]}</p>
								<p class='h4 w-100 text-center'>{$pol[2]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[3]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[4]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[5]}</p>
								<ul class='list-group mb-3'>
									<li class='list-group-item' style='text-align: justify;'>{$pol[6]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[7]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[8]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[9]}</li>
								</ul>
								<p class='w-100 text-center fw-bold'>{$pol[10]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[11]}</p>
								<ul class='list-group mb-3'>
									<li class='list-group-item' style='text-align: justify;'>{$pol[12]}<br/>{$pol[13]}<br/>{$pol[14]}<br/>{$pol[15]}</li>
								</ul>
								<p class='w-100 text-center fw-bold'>{$pol[16]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[17]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[18]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[19]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[20]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[21]}</p>
								<ul class='list-group mb-3'>
									<li class='list-group-item' style='text-align: justify;'>{$pol[22]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[23]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[24]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[25]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[26]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[27]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[28]}</li>
								</ul>
								<p class='w-100 text-center fw-bold'>{$pol[29]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[30]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[31]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[32]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[33]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[34]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[35]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[36]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[37]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[38]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[39]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[40]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[41]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[42]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[43]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[44]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[45]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[46]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[47]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[48]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[49]}</p>
								<ul class='list-group mb-3'>
									<li class='list-group-item' style='text-align: justify;'>{$pol[50]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[51]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[52]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[53]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[54]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[55]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[56]}</li>
								</ul>
								<p class='w-100' style='text-align: justify;'>{$pol[57]}</p>
								<ul class='list-group mb-3'>
									<li class='list-group-item' style='text-align: justify;'>{$pol[58]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[59]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[60]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[61]}</li>
									<li class='list-group-item' style='text-align: justify;'>{$pol[62]}</li>
								</ul>
								<p class='w-100' style='text-align: justify;'>{$pol[63]}</p>
								<ul class='list-group mb-3'>
									<li class='list-group-item' style='text-align: justify;'>{$pol[64]}<br/>{$pol[65]}<br/>{$pol[66]}</li>
								</ul>
								<p class='w-100 text-center fw-bold'>{$pol[67]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[68]}</p>
								<p class='w-100 text-center fw-bold'>{$pol[69]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[70]}</p>
								<p class='h4 w-100 text-center'>{$pol[71]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[72]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[73]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[74]}</p>
								<p class='h4 w-100 text-center'>{$pol[75]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[76]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[77]}</p>
								<p class='h4 w-100 text-center'>{$pol[78]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[79]}</p>
								<p class='h4 w-100 text-center'>{$pol[80]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[81]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[82]}</p>
								<p class='w-100' style='text-align: justify;'>{$pol[83]}</p>
							</div>
							<div class='modal-footer'>
								<button type='button' class='btn btn-dark w-100' data-bs-toggle='modal' data-bs-target='#tenantCheckin'>[[BTNS.CLOSE]]</button>
							</div>
						</div>
					</div>
				</div>
			";

			$this->html[] = $html;

		}

	}

	function generatePDF()
	{

		$this->html[] = "
			<a href='{$this->_http}doc/{$this->data['ref']}' class='btn btn-dark w-100 mt-3' target='_blank'>GENERATE PDF</a>
		";

	}

	function build()
	{

		$this->html[] = "</section>";
		$this->html[] = "<script type='text/javascript' src='{$this->_http}lib/jq.js'></script>";
		$this->html[] = "<script type='text/javascript' src='{$this->_http}lib/bs/js/bootstrap.bundle.min.js'></script>";
		if ($this->_log) {
			$this->html[] = "<script type='text/javascript' src='{$this->_http}lib/bs/js/select2.js'></script>";
			$this->html[] = "<script type='text/javascript' src='{$this->_http}lib/register.js'></script>";
		}
		$this->html[] = "</body>";
		$this->html[] = "</html>";

		foreach ($this->html as $k => $v) {

			$this->html[$k] = preg_replace_callback('/{{img:([\d]+)}}/', function ($id) {
				return $this->getImg($id[1], 'dom64');
			}, $this->html[$k]);

			$this->html[$k] = preg_replace_callback('/{{video:([\d]+)}}/', function ($id) {
				return $this->getVideo($id[1], 'dom64');
			}, $this->html[$k]);

		}

		//echo $this -> minimize ( implode ( "", $this -> html ) );
		$html = implode($this->html);
		$html = makeTranslates($html,null,'apartment.json');
		echo $html;

	}

}

?>