
<?php

require realpath ( __DIR__ . '/lib/load.php' );

if ( isset ( $_GET ['lang'] ) ) {

	$_f -> setLang ( $_GET ['lang'] );
	header ( "Location: " . strtok ( $_SERVER ['REQUEST_URI'], '?' ), true, 303 );
	exit ();

}

if ( $_f -> newUser () ) {
	// New User Content
	$_f -> loadTemplate ( TPL . 'newUser.html', [
		'name' => $_f -> getConfig('name'),
		'user' => $_f -> getConfig('user'),
		'redirect' => $_f -> getConfig('redirect'),

		'newName' => empty ( $_f -> getConfig('name') ) ? 'form-floating' : 'd-none',
		'nameActive' => !empty ( $_f -> getConfig('name') ) ? ' disabled' : '',
		'userActive' => !empty ( $_f -> getConfig('user') ) ? ' disabled' : '',
		'newPass' => empty ( $_f -> getConfig('pass') ) ? 'form-floating' : 'd-none',
		'newRedirect' => empty ( $_f -> getConfig('redirect') ) ? 'form-floating' : 'd-none'
	] );
	$_f -> build ();
} else {

	if (!isset($_COOKIE['login'])) {
	    
	    $langList = json_decode(file_get_contents(LIB.'co-co.json'),1);

		// Login Content
		$_f -> loadTemplate ( TPL . 'login.html', [
		    'areLangs'			=> call_user_func(function() use($_f) {

		        $available = array_filter ( scandir ( LNG ), fn( $d ) => $d [0] !== '.' );
		        unset($available[array_search($_f->getLang(),$available)]);

		        return count ( $available ) ? '' : ' disabled';

	        }),
	        'actualLang'		=> call_user_func(function() use ($_f,$langList) {

		        $l = $_f->getLang() === 'en' ? 'gb' : $_f->getLang();
		        $filtered = array_filter($langList, fn($v) => $v['alpha2Code'] === strtoupper($l));
		        $filtered = reset($filtered);
		        return mb_convert_case($filtered ['languages'][0]['nativeName'], MB_CASE_TITLE, 'UTF-8');

	        }),
	        'langs'				=> call_user_func(function() use($_http,$_f,$langList) {

		        $available = array_filter ( scandir ( LNG ), fn( $d ) => $d [0] !== '.' );
		        unset($available[array_search($_f->getLang(),$available)]);

		        $ret = '';

		        if(count($available)) {
			        $ret .= '<ul class="dropdown-menu">';
			        foreach($available as $v) {
				        $v = $v === 'en' ? 'gb' : $v;
				        foreach($langList as $l) {
					        if($l['alpha2Code']===strtoupper($v)){
						        $v = $v === 'gb' ? 'en' : $v;
						        $url = $_http;
						        $url .= "?" . http_build_query ( ['lang' => $v] );
						        $ret .= '<li><a class="dropdown-item" href="' . $url . '"><img src="' . ($l['flags']['svg']??'') . '" alt="' . $v . '" class="img-fluid me-2"/>' . mb_convert_case($l['languages'][0]['nativeName'], MB_CASE_TITLE, 'UTF-8') . '</a></li>';
						        break;
					        }
				        }
			        }
			        $ret .= '</ul>';
		        }

		        return $ret;

	        })
		] );

	} else {

		if ( !$_COOKIE['login'] ) {
			unset($_COOKIE['login']);
			exit();
		}

		// Start Body Container
		$_f -> loadTemplate ( '<div class="container p-5">' );

		// Tabs Container
		$_f -> loadTemplate ( TPL . 'tabs.html' );

		// Start Tabs Content Container
		$_f -> loadTemplate ( '<div class="tab-content" id="tabContent">' );

		// Apartments Content
		$_f -> loadTemplate ( TPL . 'apartments.html' );

		// Register Content
		$_f -> loadTemplate ( TPL . 'register.html' );

	}

	$content = $_f -> build ( true );

	$_f -> vacuum ();

	$_f -> loadTemplate ( TPL . 'body.html', [
		'date' => time (),

		'content' => $content,

		'langLib' => file_get_contents ( LNG . ( $_f -> getLang () ) . DIRECTORY_SEPARATOR . 'admin.json' )
	] );

	$_f -> build ();

}

?>