function addTenant () {

	var count = 0;

	$ ( document ).find ( '.nTenant' ).each ( () => { count++ } );

	var html = `
		<div class="w-100 my-2 pb-2 border-bottom nTenant">
			<div class='input-group'>
				<div class='form-floating col-6'>
					<input type='text' class='form-control' id='te-name[${count}]' name='te-name[${count}]' tabindex='0' minlength='3' placeholder='${_txt[0]}' required />
					<label for='te-name[${count}]'>${_txt[0]}</label>
				</div>
				<div class='form-floating col-6'>
					<input type='text' class='form-control' id='te-surname[${count}]' name='te-surname[${count}]' tabindex='0' minlength='3' placeholder='${_txt[1]}' required />
					<label for='te-surname[${count}]'>${_txt[1]}</label>
				</div>
			</div>
			<div class='input-group mt-2'>
				<div class='form-floating col-10'>
					<input type='text' class='form-control' id='te-doc[${count}]' name='te-doc[${count}]' tabindex='0' minlength='6' placeholder='${_txt[2]}' required />
					<label for='te-doc[${count}]'>${_txt[2]}</label>
				</div>
				<button type='button' class='btn btn-dark col-2 removeTenant'><i class='fas fa-xmark fs-1 pe-none'></i></button>
			</div>
		</div>
	`;

	$ ( document ).find ( '.addTenant' ).before ( html );

}

function removeTenant ( id ) {

	$ ( id.target ).parent ().parent ().remove ();
	var count = 0;
	var vals = ['te-name','te-surname','te-doc'];

	$ ( document ).find ( '.nTenant' ).each ( (i,e) => {

		$ ( e ).find ( 'input' ).each ( (j,f) => {

			$ ( f ).attr ( 'id', `${vals[j]}[${count}]` );
			$ ( f ).attr ( 'name', `${vals[j]}[${count}]` );

		} );

		$ ( e ).find ( 'label' ).each ( (j,f) => {
			$ ( f ).attr ( 'for', `${vals[j]}[${count}]` );
		} );

		count++;

	} );

}

function onlyNumb ( e ) {
	
	if ( e.keyCode >= 48 && e.keyCode <= 57 ) { return true; }
	if ( e.keyCode >= 96 && e.keyCode <= 105 ) { return true; }
	switch ( e.keyCode ) {
		case 8: case 9: return true; break;
	}

	return false;
}

function checkEmail ( e ) {

	var pattern = /^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,})$/i;
	if ( $ ( e.target ).val ().match ( pattern ) ) {
		$ ( e.target ).removeClass ( 'is-invalid' ).addClass ( 'is-valid' );
	} else {
		$ ( e.target ).removeClass ( 'is-valid' ).addClass ( 'is-invalid' );
	}

}

function checkReservation ( e ) {

	var pattern = /^[0-9]{4}-[A-Z]{2}-[0-9]{4}$/i;
	if ( $ ( e.target ).val ().match ( pattern ) ) {
		$ ( e.target ).removeClass ( 'is-invalid' ).addClass ( 'is-valid' );
	} else {
		$ ( e.target ).removeClass ( 'is-valid' ).addClass ( 'is-invalid' );
	}

}

$ ( document ).ready ( () => {

	var jsonCoco = fetch ( `${_u}lib/co-co.json` ).then ( (response) => response.json () );

	jsonCoco.then ( d => {
		var data = [];
		for ( var i of d ) {
			data.push ( { id: i.callingCodes [0], text: `+${i.callingCodes[0]}`, html: `
				<div class="d-flex flex-wrap">
					<div class="col-4 text-center"><img src="${i.flags.png}" class="img-fluid" /></div>
					<div class="col-8 fw-bold text-end">+${i.callingCodes[0]}</div>
					<div class="col-12 text-muted" style="font-size:0.75rem;">${i.name}</div>
				</div>
			`, selected: i.callingCodes[0] == 34 ? true : false, title: `
				<div class="position-absolute top-50 start-50 d-flex translate-middle">
					<div class="col-4 text-center"><img src="${i.flags.png}" class="img-fluid" /></div>
					<div class="col-8 text-end">+${i.callingCodes[0]}</div>
				</div>
			`, country: i.name.toLowerCase () } );
		}
		$ ( '#te-coco' ).select2 ( {
			data: data,
			templateResult: d => { return d.html; },
			escapeMarkup: d => { return d; },
			templateSelection: d => { return d.title; },
			matcher: (p,d) => {
				if ( $.trim ( p.term ) === '' ) { return d; }
				if ( typeof d.text === 'undefined' ) { return null; }
				if ( d.text.indexOf ( p.term ) > -1 || d.country.indexOf ( p.term ) > -1 ) {
					var md = $.extend ( {}, d, true );
					md.text += ` (matched)`;
					return md;
				}
				return null;
			},
			theme: 'bootstrap-5',
			dropdownParent: $ ( '#tenantCheckin' ),
			minimumResultsForSearch: 3,
			placeholder: $ ( '#te-coco' ).attr ( 'placeholder' ),
			language: _l
		} );
	} );

	const modalRegister = new bootstrap.Modal ( '#tenantCheckin', {
		keyboard: false
	} );

	modalRegister.show ();

	$ ( document ).on ( 'click', '.addTenant', addTenant );
	$ ( document ).on ( 'click', '.removeTenant', removeTenant );

	$ ( document ).on ( 'submit', '#newTentants', f => {

		var form = $ ( f.target );

		if ( !f.target.checkValidity () ) {
			f.preventDefault ();
			f.stopPropagation ();

			form.addClass ( 'was-validated' );
		} else {

			if ( $ ( document ).find ( '.is-invalid' ).length > 0 ) {
				f.preventDefault ();
				f.stopPropagation ();

				form.addClass ( 'was-validated' );
			} else {

				$.post ( `${_u}lib/_aj`, form.serialize (), d => {
					if ( d.done ) {
						modalRegister.hide ();
						modalRegister.on ( 'hidden.bs.modal', () => {
							$ ( document ).find ( '.modal' ).remove ();
						} );
					} else {
						$ ( 'input[id="te-booking"]' ).val ( '' ).focus ().removeClass ( 'is-valid' ).addClass ( 'is-invalid' );
					}
				}, 'json' );

			}

		}

		return false;

	} );

} );