<?php

ini_set ( 'html_errors', 0 );
ini_set ( 'display_errors', 1 );

set_error_handler ( function ( $errno, $errstr, $errfile, $errline ) {

	http_response_code ( 500 );
	echo json_encode ( [
		'error'		=> true,
		'message'	=> $errstr,
		'file'		=> $errfile,
		'line'		=> $errline
	] );
	exit;

} );

define ( 'DIR', realpath ( __DIR__ . '/../' ) . DIRECTORY_SEPARATOR );
define ( 'LIB', realpath ( __DIR__ . '/' ) . DIRECTORY_SEPARATOR );
define ( 'LNG', realpath ( __DIR__ . '/../lang' ) . DIRECTORY_SEPARATOR );
define ( 'TPL', realpath ( __DIR__ . '/../template' ) . DIRECTORY_SEPARATOR );

date_default_timezone_set ( "Europe/Madrid" );
$_http = ( isset ( $_SERVER['HTTPS'] ) ? 'https://' : 'http://' ) . $_SERVER['SERVER_NAME'] . '/';

class funcs {

	private $lang = 'en';
	private $html = [];
	private $_config = DIR . 'config.json';


	function __construct () {

		if ( !file_exists ( $this -> _config ) ) {
			throw new Error ( "Config file not exists!" );
		}

		$_c = file_get_contents ( $this -> _config );
		$this -> _config = json_decode ( $_c, 1 );

		$this -> setLang ();

	}

	function newUser () {

		foreach ( $this -> _config as $k => $v ) {
			if ( $k == 'name' && empty ( $v ) ) { return true; exit (); }
			if ( $k == 'user' && empty ( $v ) ) { return true; exit (); }
			if ( $k == 'pass' && empty ( $v ) ) { return true; exit (); }
			if ( $k == 'redirect' && empty ( $v ) ) { return true; exit (); }
		}

	}

	function setLang ( $lang = null ) {

		$available = array_filter ( scandir ( LNG ), fn( $d ) => $d [0] !== '.' );

		if ( $lang && in_array ( $lang, $available ) ) {
			if ( !isset ( $_COOKIE ['lang'] ) || $_COOKIE ['lang'] !== $lang ) {
				setcookie ( 'lang', $lang, time () + 3600 * 4, "/" );
			}
			$this -> lang = $lang;
			return;
		}

		if ( isset ( $_COOKIE ['lang'] ) && in_array ( $_COOKIE ['lang'], $available ) ) {
			$this -> lang = $_COOKIE ['lang'];
			return;
		}

		$brLang = substr ( $_SERVER ['HTTP_ACCEPT_LANGUAGE'], 0, 2 );
		$lang = in_array ( $brLang, $available ) ? $brLang : 'en';

		setcookie ( 'lang', $lang, time () + 3600 * 4, "/" );

		$this -> lang = $lang;

	}

	function getLang () {

		return $this -> lang;

	}

	function login ( $user, $pass ) {



	}

	function setConfig ( $label, $value ) {

		$this -> _config [$label] = $value;

		if ( in_array ( $label, ['user', 'SESentity', 'SESuser', 'SESpass'] ) ) {
			$this -> _config [$label] = bin2hex ( base64_encode ( $value ) );
		}

		if ( $label == 'pass' ) {
			$this -> _config [$label] = password_hash ( $value, PASSWORD_BCRYPT, ['cost' => 11] );
		}

		$_c = json_encode ( $this -> _config, JSON_UNESCAPED_UNICODE );
		file_put_contents ( DIR . 'config.json', $_c );

	}

	function getConfig ( $label ) {

		if ( !isset ( $this -> _config [$label] ) ) {
			return false;
		}

		if ( !in_array($label, ["limitApartment","limitRegister","SESentity","SESuser","SESpass"]) && ctype_xdigit ( $this -> _config [$label] ) ) {
			return base64_decode ( hex2bin ( $this -> _config [$label] ) );
		} else {
			return $this -> _config [$label];
		}

	}

	function minizeHTML ( $html ) {

		return preg_replace([
				'/(\n|^)(\x20+|\t)/',
				'/(\n|^)\/\/(.*?)(\n|$)/',
				'/\n/',
				'/\<\!--.*?-->/',
				'/(\x20+|\t)/',
				'/\>\s+\</',
				'/(\"|\')\s+\>/',
				'/=\s+(\"|\')/'
			], [
				"\n",
				"\n",
				" ",
				"",
				" ",
				"><",
				"$1>",
				"=$1"
			], $html);

	}

	function token($len=20){

		$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
		$string = '';

		$chars = str_split($chars);

		for($i=0;$i<$len;$i++){
			if(rand(0,1)){
				$string .= $chars[rand(0,count($chars)-1)];
			}else{
				$string .= strtolower($chars[rand(0,count($chars)-1)]);
			}
		}

		return $string;

	}

	function makeTranslates ( $html, $lang = null, $file = 'admin.json', $returnArray = false ) {

		static $langCache = [];
		$lang = $lang ?? $this -> lang ?? $_COOKIE ['lang'] ?? 'en';

		if ( !isset ( $langCache [$lang] ) ) {

			$path = realpath ( LNG . $lang . DIRECTORY_SEPARATOR . $file );

			if ( $path && file_exists ( $path ) ) {
				$langCache [$lang] = json_decode ( file_get_contents ( $path ), 1 );
			} else {
				$langCache [$lang] = [];
			}

		}

		$_l = $langCache [$lang];

		if ( $returnArray && preg_match ( '/^\[\[(.+?)\]\]$/', trim ( $html ), $match ) ) {

			$path = explode ( '.', trim ( $match [1] ) );
			$current = $_l;

			foreach ( $path as $value ) {

				if ( is_array ( $current ) && array_key_exists ( $value, $current ) ) {
					$current = $current [$value];
				} else {
					return null;
				}

			}

			return $current;

		}

		$html = preg_replace_callback ( '/\[\[(.+?)\]\]/', function ( $v ) use ( $_l, $returnArray ) {

			$path = trim ( $v [1] );
			$path = explode ( '.', $path );

			$current = $_l;

			if ( !count ( $path ) ) {
				return $v [1];
			}

			foreach ( $path as $value ) {

				if ( is_array ( $current ) && array_key_exists ( $value, $current ) ) {
					$current = $current [$value];
				} else {
					return $v [1];
				}

			}

			if ( !$returnArray && is_array ( $current ) ) {
				return $v [1];
			}

			return $current;

		}, $html );

		return $html;

	}

	function translate ( $text, $lang = null, $file = 'admin.json', $returnArray = false ) {

		return $this -> makeTranslates ( "[[{$text}]]", $lang, $file, $returnArray );

	}

	function loadTemplate ( $template, $opts = [], $return = false ) {

		$lang = $opts ['lang'] ?? $this -> lang ?? $_COOKIE ['lang'] ?? 'en';

		if ( file_exists ( $template ) ) {
			$html = file_get_contents ( $template );
		} else {
			$html = $template;
		}

		$html = $this -> makeTranslates ( $html, null, $opts ['file'] ?? 'admin.json' );

		if ( !empty ( $this->getConfig('name') ) ) {
			$html = str_replace ( '{{titleName}}', $this->getConfig('name') . ' :: ', $html );
		}
		if ( !empty ( $this->getConfig('logo') ) ) {
			$html = str_replace ( '{{logo}}', $this->getConfig('logo'), $html );
		}
		$html = str_replace ( '{{lang}}', $lang, $html );
		$html = str_replace ( '{{langDP}}', $lang == 'en' ? 'en-GB' : $lang, $html );
		$html = str_replace ( '{{http}}', $GLOBALS ['_http'], $html );
		$html = str_replace ( '{{redirect}}', $this -> getConfig('redirect'), $html);
		$html = str_replace ( '{{_config}}', json_encode ( [
			'apartment'		=> (int) $this -> getConfig('limitApartment'),
			'register'		=> (int) $this -> getConfig('limitRegister')
		] ), $html);
		$html = str_replace ( '{{name}}', $this->getConfig('name'), $html);

		foreach ( $opts as $k => $v ) {

			$html = str_replace ( '{{' . $k . '}}', $v ?? '', $html );

		}

		$this -> html [] = $html;

		if ( $return ) {
			return $html;
		}

	}

	function _pagination ( $total, $limit, $page ) {

		if ( $page < 1 ) { $page = 1; }
		if ( $limit < 1 ) { $limit = 1; }

		$ret = [
			'pages' => 0,
			'page' => (int) $page,
			'next' => (bool) false,
			'total' => (int) $total,
			'limit' => [
				'limit' => (int) $limit,
				'start' => 0,
				'end' => 0
			]
		];

		if ( $total <= $limit ) {
			$ret ['pages'] = 1;
			$ret ['limit'] ['end'] = (int) $total;
		} else {
			$ret ['pages'] = (int) ceil ( $total / $limit );
			if ( $page > $ret ['pages'] ) { $page = $ret ['pages']; }
			$ret ['limit'] ['start'] = ( $page - 1 ) * $limit;
			$ret ['limit'] ['end'] = ( $ret ['limit'] ['start'] + $limit ) > $total ? $total : $ret ['limit'] ['start'] + $limit;
			if ( $ret ['limit'] ['end'] !== $total ) { $ret ['next'] = true; }
		}

		return $ret;

	}

	function build ( $return = false ) {

		$html = implode ( $this -> html );
		$html = $this -> minizeHTML ( $html );

		if ( $return ) {
			return $html;
		} else {
			echo $html;
		}

	}

	function vacuum () {

		$this -> html = [];

	}

	function _json ( $data ) {

		header('Content-Type: application/json');
		echo json_encode($data, JSON_UNESCAPED_UNICODE);

	}

}

$_f = new funcs ();

?>