var modal = {
	modal: null,
	domuid: null,
	bsModal: null
};

var filters = {
	apart: {
		ref: '',
		name: '',
		sesid: ''
	},
	register: {
		booking: '',
		ref: '',
		checkin: '',
		checkout: '',
		tenant: ''
	}
};

var pagination = {
	apart: 0,
	register: 0
};

var loading = false;

var registerCreating = false;

function getCookie(cname) {

	var name = `${cname}=`;
	var decodedCookie = decodeURIComponent(document.cookie);
	var ca = decodedCookie.split(';');
	for (var i = 0; i < ca.length; i++) {
		var c = ca[i];
		while (c.charAt(0) == ' ') {
			c = c.substring(1);
		}
		if (c.indexOf(name) == 0) {
			return c.substring(name.length, c.length);
		}
	}
	return "";

}
function getLangs() {
	if (!getCookie('login')) { return false; }
	var ret = null;
	$.ajax({
		url: `${_u}lib/_aj.php`,
		method: 'POST',
		async: false,
		cache: false,
		data: { t: 'getLangs' },
		dataType: 'json',
		success: (d) => ret = d
	});
	return ret;
}
function limits(type) {
	if(typeof type === 'undefined') return false;

	let ret = false;

	$modal = $(`
		<div class="modal fade" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
			<div class="modal-dialog modal-sm modal-dialog-centered modal-dialog-scrollable">
				<div class="modal-content">
					<div class="modal-body text-center">
						<h4>${_lang.ERRORS.LIMITED}</h4>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark w-100" data-bs-dismiss="modal" aria-label="Close">${_lang.BTNS.ACCEPT}</button>
					</div>
				</div>
			</div>
		</div>
	`).appendTo('body');

	const $bsModal = new bootstrap.Modal($modal);

	function clearModal () {
		try {
			$modal.off('hidden.bs.modal');
			$bsModal.hide();
			$bsModal.dispose();
			$modal.remove();
		} catch (e) {}
	}

	$modal.one('hidden.bs.modal', clearModal);

	let limit = 0;
	let count = 0;

	switch(type) {
		case 'apart':
			limit = _config.apartment;
			count = $(document).find('.apartment-list tr').length;

			if (limit === -1 || count < limit) {
				ret = true;
			}
			break;
		case 'reg':
			limit = _config.register;
			count = $(document).find('.register-list tr').length;

			if(limit === -1 || count < limit) {
				ret = true;
			}
			break;
	}

	if (!ret) {
		$bsModal.show();
	} else {
		clearModal();
	}

	return ret;
}
function apartList(p) {
	if (!getCookie('login')) { return false; }
	if (loading) { setTimeout ( () => apartList(p), 1000 ); return false; }
	$('.apartment-list').html('');
	if (!p || typeof p === 'undefined') { p = 0; }

	loading = true;
	$.post(`${_u}lib/_aj.php`, { t: 'apart-list', p, filter: filters.apart }, d => {
		if (d.done) {
			if ( d.data.length ) {
				for (var i of d.data) {
					$('.apartment-list').append(`
						<tr>
							<th scope="row" class="text-center align-middle">${i.id}</th>
							<td class="align-middle" data-id="${i.id}" data-name="ref">${i.ref}</td>
							<td class="align-middle text-truncate" data-id="${i.id}" data-name="name">${i.name}</td>
							<td class="align-middle text-center">${i.sesid}</td>

							<td class="text-center align-middle flex-nowrap">
								<div class="btn-group btn-group-sm me-3" role="group" aria-label="Options">
									<button type="button" class="btn btn-outline-dark apartEdit" data-id="${i.id}"><i class="fas fa-pen-to-square pe-none"></i></button>
									<button type="button" class="btn btn-outline-dark copyclip" data-url="${_u}${i.ref}/form"><i class="fas fa-link pe-none"></i></button>
								</div>
								<div class="btn-group btn-group-sm" role="group" aria-label="Options">
									<button type="button" class="btn btn-outline-dark apartRemove" data-id="${i.id}"><i class="fas fa-trash-can pe-none"></i></button>
								</div>
							</td>
						</tr>
					` );
					$(document).find(`select.apartBox[data-id="${i.id}"] option[value="${i.box}"]`).prop('selected', true);
				}
			}
			$('div.apartFooter div.pages').html(buildPagination(d.pages,d.page,'apartPag'));
			pagination.apart = d.page;
			$('div.apartFooter div.total').html(d.total);
		} else {
			$('.apartment-list').append(`
				<tr>
					<td colspan="5" class="text-center">${_lang.ERRORS.EMPTYAPARTMENT}</td>
				</tr>
			`);
		}
		loading = false;
	}, 'json');
}

function filterApart (e) {

	filters.apart = {
		ref: $('#filter-apartments input[name="ref"]').val(),
		name: $('#filter-apartments input[name="name"]').val(),
		sesid: $('#filter-apartments input[name="sesid"]').val()
	};

	apartList (0);

}

function registerList(p) {
	if (!getCookie('login')) { return false; }
	if (loading) { setTimeout ( () => registerList(p), 1000 ); return false; }
	$('.register-list').html('');
	if (!p || typeof p === 'undefined') { p = 0; }
	loading = true;
	$.post(`${_u}lib/_aj.php`, {t:'register-list', p, filter: filters.register}, d => {
		if (d.done) {
			if(d.data.length) {
				var oldStart = 0;
				for (var i of d.data) {
					if (i.old) { oldStart++; }
					$('.register-list').append(`
						<tr${oldStart == 1 ? ` class="border-top border-dark"` : ''}>
							<th scope="row" class="text-center align-middle copyclip" data-url="${i.reservation}">${i.reservation}</th>
							<td class="text-center align-middle">${i.ref}</td>
							<td class="text-center align-middle">${i.start} (${i.days.start})</td>
							<td class="text-center align-middle">${i.end} (${i.days.end})</td>
							<td class="text-center align-middle${i.sended ? ` text-success` : ` text-danger`} registerView" data-id="${i.id}">${i.sended ? _lang.MISC.YES : _lang.MISC.NO}</td>
							<td class="text-center">
								<div class="btn-group btn-group-sm me-3" role="group" aria-label="Options">
									${!i.sended?`<button type="button" class="btn btn-outline-dark registerEdit" data-id="${i.id}"><i class="fas fa-pen-to-square pe-none"></i></button>`:''}
									<button type="button" class="btn btn-outline-dark registerView" data-id="${i.id}"><i class="fas fa-eye pe-none"></i></button>
									${!i.sended&&i.link!=''?`<button type="button" class="btn btn-outline-dark copyclip" data-url="${i.link}"><i class="fas fa-link pe-none"></i></button>`:''}
									<button type="button" class="btn btn-outline-dark registerVisit" data-id="${i.id}" data-value="${i.reservation}"><i class="fas fa-paper-plane pe-none"></i></button>
								</div>
								<div class="btn-group btn-group-sm" role="group" aria-label="Options">
								    ${i.sended?`<button type="button" class="btn btn-outline-dark duplicateRegister" data-id="${i.id}"><i class="fas fa-copy pe-none"></i></button>`:''}
									${!i.sended?`<button type="button" class="btn btn-outline-dark registerRemove" data-id="${i.id}"><i class="fas fa-trash-can pe-none"></i></button>`:''}
									<!-- <button type="button" class="btn btn-outline-dark registerRemove" data-id="${i.id}"><i class="fas fa-trash-can pe-none"></i></button> -->
								</div>
							</td>
						</tr>
					` );
				}
			}
			$ ('div.registerFooter div.pages').html (buildPagination(d.pages,d.page,'registerPag'));
			pagination.register = d.page;
			$('div.registerFooter div.total').html(d.total);
		} else {
			$('.register-list').append(`
				<tr>
					<td colspan="6" class="text-center">${_lang.ERRORS.EMPTYREGISTER}</td>
				</tr>
			`);
		}
		loading = false;
	}, 'json');
}

function filterRegister (e) {

	filters.register = {
		booking: $('#filter-registers input[name="booking"]').val(),
		ref: $('#filter-registers input[name="ref"]').val(),
		checkin: $('#filter-registers input[name="checkin"]').val(),
		checkout: $('#filter-registers input[name="checkout"]').val(),
		tenant: $('#filter-registers input[name="tenant"]').val(),
	};

	registerList (0);

}

function addApartment(data) {

	if (!getCookie('login')) { return false; }

	data = $.extend({
		id: 0,
		title: _lang.FORM.APARTMENTS.ADD,
		type: "addApart",
		ref: "",
		name: "",
		sesid: ''
	}, data);

	modal.modal = $('body').append(`
		<div class="modal fade" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
			<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<h1 class="modal-title fs-5">${data.title}</h1>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<form id="formApart" autocomplete="off" autocapitalize="off">
							<input type="hidden" name="t" value="${data.type}" />
							<input type="hidden" name="uid" value="${data.id}" />
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="ref" name="ref" placeholder="${_lang.FORM.APARTMENTS.REF}" value="${data.ref}" required />
								<label for="ref">${_lang.FORM.APARTMENTS.REF}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="name" name="name" placeholder="${_lang.FORM.APARTMENTS.NAME}" value="${data.name}" required />
								<label for="name">${_lang.FORM.APARTMENTS.NAME}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="sesid" name="sesid" placeholder="${_lang.FORM.APARTMENTS.SESID}" value="${data.sesid}" required />
								<label for="sesid">${_lang.FORM.APARTMENTS.SESID}</label>
							</div>
						</form>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark submitApart">${_lang.BTNS.SAVE}</button>
					</div>
				</div>
			</div>
		</div>
	` );

	modal.domuid = $(document).find('.modal');
	modal.bsModal = new bootstrap.Modal(modal.domuid);
	modal.bsModal.toggle();
	modal.domuid.on('hidden.bs.modal', () => {
		modal.domuid.off('hidden.bs.modal');
		modal.bsModal.dispose();
		modal.domuid.remove();
		modal.bsModal = null;
		modal.domuid = null;
		modal.modal = null;
	});

}

function addRegister(data) {

	if (!getCookie('login')) { return false; }

	data = $.extend({
		id: 0,
		title: _lang.FORM.REGISTER.ADD,
		type: 'addRegister',
		reservation: '',
		contractDate: new Date (_date*1000),
		ref: 0,
		start: new Date (_date*1000),
		end: new Date ((_date+(60*60*24))*1000),
		paycardDate: new Date(_date*1000),
		paymentType: '',
		paymentValue: '',
		cardOwner: '',
		cardExpire: '',
		tenants: []
	}, data);

	if ( data.id > 0 ) {
		data.start = new Date(data.start);
		data.end = new Date(data.end);
		data.contractDate = new Date(data.contractDate);
		data.paycardDate = new Date(data.paycardDate);
	}

	var dates = {
		start: (data.start / 1000).toFixed(0),
		end: (data.end / 1000).toFixed(0),
		contractDate: (data.contractDate / 1000).toFixed(0),
		paycardDate: (data.paycardDate / 1000).toFixed(0)
	};

	var getRefs = function () {

		if (!getCookie('login')) { return false; }

		var ret = new Array();

		$.ajax({
			url: `${_u}lib/_aj.php`,
			method: 'POST',
			async: false,
			cache: false,
			data: { t: 'getRefs' },
			dataType: 'json',
			success: (d) => {
				if (d.done) {
					for (var i of d.data) {
						ret.push(`<option value="${i.ref}">${i.ref}: ${i.name}</option>`);
					}
				}
			}
		});

		return ret;

	}();

	modal.modal = $('body').append(`
		<div class="modal fade" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
			<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
				<div class="modal-content">
					<div class="modal-header">
						<h1 class="modal-title fs-5">${data.title}</h1>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<form id="formRegister">
							<input type="hidden" name="t" value="${data.type}" />
							<input type="hidden" name="uid" value="${data.id}" />
							<input type="hidden" name="date-values" id="date-values" value="${Object.values(dates).join(',')}" />
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="reg-reservation" maxlength="50" name="reservation" placeholder="${_lang.FORM.REGISTER.NUMBER}" value="${data.reservation}" />
								<label for="reg-reservation">${_lang.FORM.REGISTER.NUMBER}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="reg-contract-date" name="contractDate" placeholder="${_lang.FORM.REGISTER.CONTRACTDATE}" value="${data.contractDate.getDate().toString().padStart(2,'0')}/${(data.contractDate.getMonth()+1).toString().padStart(2,'0')}/${data.contractDate.getFullYear()}" required />
								<label for="reg-contract-date">${_lang.FORM.REGISTER.CONTRACTDATE}</label>
							</div>
							<div class="form-floating mb-3">
								<select class="form-select" placeholder="${_lang.FORM.REGISTER.REF}" name="ref" id="reg-ref">
									${getRefs}
								</select>
								<label for="reg-ref">${_lang.FORM.REGISTER.REF}</label>
							</div>
							<div class="input-group mb-3">
								<div class="form-floating col-6">
									<input type="text" class="form-control" id="reg-start" name="start" placeholder="${_lang.FORM.REGISTER.CHECKIN}" value="${data.start.getDate().toString().padStart(2,'0')}/${(data.start.getMonth()+1).toString().padStart(2,'0')}/${data.start.getFullYear()}" required />
									<label for="reg-start">${_lang.FORM.REGISTER.CHECKIN}</label>
								</div>
								<div class="form-floating col-6">
									<input type="text" class="form-control" id="reg-end" name="end" placeholder="${_lang.FORM.REGISTER.CHECKOUT}" value="${data.end.getDate().toString().padStart(2,'0')}/${(data.end.getMonth()+1).toString().padStart(2,'0')}/${data.end.getFullYear()}" required />
									<label for="reg-end">${_lang.FORM.REGISTER.CHECKOUT}</label>
								</div>
							</div>

							<h1 class="fs-4 bg-dark text-white p-3 rounded mb-3">${_lang.LABELS.PAYMENT}</h1>

							<div class="form-floating mb-3">
								<select class="form-select" placeholder="${_lang.FORM.REGISTER.PAYMENTTYPE}" name="paymentType" id="paymentType">
									${$.map(_lang.FORM.REGISTER.PAYMENTSTYPES,(v,k)=>`<option value="${k}"${k==data.paymentType?` selected`:''}>${v}</option>`).join('')}
								</select>
								<label for="paymentType">${_lang.FORM.REGISTER.PAYMENTTYPE}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="reg-paycard-date" name="paycard-date" placeholder="${_lang.FORM.REGISTER.PAYMENTDATE}" value="${data.paycardDate.getDate().toString().padStart(2,'0')}/${(data.paycardDate.getMonth()+1).toString().padStart(2,'0')}/${data.paycardDate.getFullYear()}" required />
								<label for="reg-paycard-date">${_lang.FORM.REGISTER.PAYMENTDATE}</label>
							</div>
							<div class="form-floating">
								<input type="text" class="form-control" id="paymentValue" name="paymentValue" maxlength="50" placeholder="${_lang.FORM.REGISTER.PAYMENTMETHOD}" value="${data.paymentValue}" />
								<label for="paymentValue">${_lang.FORM.REGISTER.PAYMENTMETHOD}</label>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.FORM.REGISTER.PAYMENTVALUEDESCRIPTION}</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="cardOwner" name="cardOwner" maxlength="100" placeholder="${_lang.FORM.REGISTER.CARDTITLE}" value="${data.cardOwner}" />
								<label for="cardOwner">${_lang.FORM.REGISTER.CARDTITLE}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="cardExpire" name="cardExpire" maxlength="7" minlength="7" placeholder="${_lang.FORM.REGISTER.EXPIRYDATE}" value="${data.cardExpire}" oninput="inputCardExpire(event)" onblur="blurCardExpire(event)" />
								<label for="cardExpire">${_lang.FORM.REGISTER.EXPIRYDATE}</label>
							</div>

							<h1 class="fs-4 bg-dark text-white p-3 rounded mb-3">${_lang.LABELS.TENANTS}</h1>

							<button type="button" class="btn btn-dark w-100 addTenant">${_lang.FORM.REGISTER.TENANT.ADD}</button>

							${$.map(data.tenants,(v,k)=>{
								const json = JSON.parse(v);
								return `
									<div class="d-flex justify-content-between align-items-center tenantBlock p-2 mt-3 rounded" style="background-color:var(--bs-gray-500);" data-id="${k}">
									<div class="col-5 text-center">${json.name} ${json.surname}</div>
									<div class="col-4 text-center">${_lang.FORM.REGISTER.TENANT.RELATIONTYPES[json.relation]}</div>
									<div class="col text-center">
										<button type="button" class="btn btn-sm btn-dark editTenant" data-id="${k}"><i class="fas fa-pen-to-square pe-none"></i></button>
										<button type="button" class="btn btn-sm btn-dark removeTenant" data-id="${k}"><i class="fas fa-trash-can pe-none"></i></button>
									</div>
								</div>
								<input type="hidden" name="tenant[${k}]" value='${v}' />
								`;
							}).join('')}
						</form>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark submitRegister">${_lang.BTNS.SAVE}</button>
					</div>
				</div>
			</div>
		</div>
	` );

	modal.domuid = $(document).find('.modal');
	modal.bsModal = new bootstrap.Modal(modal.domuid);
	modal.bsModal.toggle();
	modal.domuid.on('shown.bs.modal', () => {
		if ( registerCreating ) { return; }
		$(document).find(`select[name="ref"] option[value="${data.ref}"]`).prop('selected', true);
		// Contract Date datepicker
		$(document).find('#reg-contract-date').datepicker({
			todayHighlight: true,
			autoclose: true,
			endDate: new Date(_date*1000),
			format: {
				toDisplay: d => {
					var fd = new Date(d);
					fd.setHours(0,0,0,0);
					var dv = $(document).find('#date-values').val().split(',');
					dv[2] = (fd.getTime() / 1000) + (60 * 60 * 12);
					$(document).find('#date-values').val(dv.join(','));
					return `${fd.getDate().toString().padStart(2,'0')}/${(fd.getMonth()+1).toString().padStart(2,'0')}/${fd.getFullYear()}`;
				},
				toValue: d => d
			},
			language: _l
		});
		$(document).find('#reg-contract-date').datepicker('update', data.contractDate);
		// Checkin datepicker
		$(document).find('#reg-start').datepicker({
			todayHighlight: true,
			autoclose: true,
			format: {
				toDisplay: d => {
					var fd = new Date(d);
					fd.setHours(0,0,0,0);
					var dv = $(document).find('#date-values').val().split(',');
					dv[0] = (fd.getTime() / 1000) + (60 * 60 * 14);
					$(document).find('#date-values').val(dv.join(','));
					return `${fd.getDate().toString().padStart(2,'0')}/${(fd.getMonth()+1).toString().padStart(2,'0')}/${fd.getFullYear()}`;
				},
				toValue: d => d
			},
			language: _l
		});
		// Checkout datepicker
		$(document).find('#reg-end').datepicker({
			todayHighlight: true,
			autoclose: true,
			format: {
				toDisplay: d => {
					var fd = new Date(d);
					fd.setHours(0,0,0,0);
					var dv = $(document).find('#date-values').val().split(',');
					dv[1] = (fd.getTime() / 1000) + (60 * 60 * 12);
					$(document).find('#date-values').val(dv.join(','));
					return `${fd.getDate().toString().padStart(2,'0')}/${(fd.getMonth()+1).toString().padStart(2,'0')}/${fd.getFullYear()}`;
				},
				toValue: d => d
			},
			language: _l
		});
		setTimeout ( () => {
			$(document).find('#reg-start').datepicker('setEndDate', data.end);
			$(document).find('#reg-end').datepicker('setStartDate', data.start);

			$(document).find('#reg-start').datepicker('update', data.start);
			$(document).find('#reg-end').datepicker('update', data.end);
			// Date Events
			$(document).find('#reg-start').datepicker().on('changeDate', e => {
				$(document).find('#reg-end').datepicker('setStartDate', e.date);
			});
			$(document).find('#reg-end').datepicker().on('changeDate', e => {
				$(document).find('#reg-start').datepicker('setEndDate', e.date);
			});
		}, 300 );
		// Paycard Date datepicker
		$(document).find('#reg-paycard-date').datepicker({
			todayHighlight: true,
			autoclose: true,
			format: {
				toDisplay: d => {
					var fd = new Date(d);
					fd.setHours(0,0,0,0);
					var dv = $(document).find('#date-values').val().split(',');
					dv[3] = (fd.getTime() / 1000) + (60 * 60 * 12);
					$(document).find('#date-values').val(dv.join(','));
					return `${fd.getDate().toString().padStart(2,'0')}/${(fd.getMonth()+1).toString().padStart(2,'0')}/${fd.getFullYear()}`;
				},
				toValue: d => d,
			},
			language: _l
		});
		$(document).find('#reg-paycard-date').datepicker('update', data.paycardDate);
	});
	modal.domuid.on('hidden.bs.modal', () => {
		if ( registerCreating ) { return; }
		modal.domuid.find('.addTenant').off('click');
		$(document).find('#reg-contract-date').datepicker('destroy');
		$(document).find('#reg-start').datepicker('destroy');
		$(document).find('#reg-end').datepicker('destroy');
		$(document).off('click','.editTenant');
		$(document).off('click','.removeTenant');
		modal.domuid.off('shown.bs.modal');
		modal.domuid.off('hidden.bs.modal');
		modal.bsModal.dispose();
		modal.domuid.remove();
		modal.bsModal = null;
		modal.domuid = null;
		modal.modal = null;
	});

	modal.domuid.find('.addTenant').on('click', e => {
		registerCreating = true;
		modal.bsModal.toggle();
		addTenant();
	});

	$(document).on('click','.editTenant', e => {
		registerCreating = true;
		modal.bsModal.toggle();
		const uid = $(e.target).data('id');
		let values = modal.domuid.find(`input[name="tenant[${uid}]"]`).val();
		values = JSON.parse(values);
		addTenant($.extend({id:uid,edit:true,title:_lang.FORM.REGISTER.TENANT.EDIT},values));
	});

	$(document).on('click','.removeTenant', e => {

		const uid = $(e.target).data('id');
		modal.domuid.find(`.tenantBlock[data-id="${uid}"],input[name="tenant[${uid}]"]`).remove();

		modal.domuid.find('.tenantBlock').each((k,i)=>{
			const actualUid = $(i).data('id');
			$(i).attr('data-id',k);
			$(i).find('.editTenant').attr('data-id',k);
			$(i).find('.removeTenant').attr('data-id',k);
			modal.domuid.find(`input[name="tenant[${actualUid}]"]`).attr('name', `tenant[${k}]`);
		});

	});
}

function addTenant(data){

	if (!getCookie('login')) { return false; }

	data = $.extend({
		edit: false,
		id: modal.domuid.find('.tenantBlock').length,
		title: _lang.FORM.REGISTER.TENANT.ADD,
		type: 'VI',
		name: '',
		surname: '',
		secondsurname: '',
		docType: '',
		number: '',
		docNumber: '',
		birth: Date.now(),
		birthDay: new Date ().getDate ().toString ().padStart (2,'0'),
		birthMonth: (new Date ().getMonth () + 1).toString ().padStart (2,'0'),
		birthYear: new Date ().getFullYear (),
		nationality: 'ESP',
		genre: '',
		adress: [],
		zip: '',
		city: '0',
		locality: '',
		country: 'ESP',
		phone: [],
		email: '',
		relation: 'NULL'
	}, data);

	data.birth = new Date(data.birth*1000);

	$modal = $(`
		<div class="modal fade" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
			<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
				<div class="modal-content">
					<div class="modal-header">
						<h1 class="modal-title fs-5">${data.title}</h1>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<form id="tenant">
							<div class="form-floating mb-3">
								<select class="form-select" placeholder="${_lang.FORM.REGISTER.TENANT.TYPE}" name="type" id="type">
									${$.map(_lang.FORM.REGISTER.TENANT.TYPES,(v,k)=>`<option value="${k}"${k==data.type?` selected`:''}>${v}</option>`).join('')}
								</select>
								<label for="type">${_lang.FORM.REGISTER.TENANT.TYPE}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="name" name="name" maxlength="50" placeholder="${_lang.FORM.REGISTER.TENANT.NAME}" value="${data.name}" required />
								<label for="name">${_lang.FORM.REGISTER.TENANT.NAME}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="surname" name="surname" maxlength="50" placeholder="${_lang.FORM.REGISTER.TENANT.SURNAME}" value="${data.surname}" required />
								<label for="surname">${_lang.FORM.REGISTER.TENANT.SURNAME}</label>
							</div>
							<div class="form-floating">
								<input type="text" class="form-control" id="secondsurname" name="secondsurname" maxlength="50" placeholder="${_lang.FORM.REGISTER.TENANT.SECONDSURNAME}" value="${data.secondsurname}" />
								<label for="secondsurname">${_lang.FORM.REGISTER.TENANT.SECONDSURNAME}</label>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.FORM.REGISTER.TENANT.SECONDSURNAMEMANDATORY}</div>
							<div class="form-floating mb-3">
								<select class="form-select" placeholder="${_lang.FORM.REGISTER.TENANT.DOC}" name="docType" id="docType">
									${$.map(_lang.FORM.REGISTER.TENANT.DOCTYPES,(v,k)=>`<option value="${k}"${k==data.docType?` selected`:''}>${v}</option>`).join('')}
								</select>
								<label for="docType">${_lang.FORM.REGISTER.TENANT.DOC}</label>
							</div>
							<div class="form-floating">
								<input type="text" class="form-control" id="number" name="number" maxlength="15" placeholder="${_lang.FORM.REGISTER.TENANT.DOCNUMBER}" value="${data.number}" />
								<label for="number">${_lang.FORM.REGISTER.TENANT.DOCNUMBER}</label>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.FORM.REGISTER.TENANT.DOCNUMBERMANDATORY}</div>
							<div class="form-floating">
								<input type="text" class="form-control" id="docNumber" name="docNumber" maxlength="9" placeholder="${_lang.FORM.REGISTER.TENANT.DOCSUPPORT}" value="${data.docNumber}" />
								<label for="docNumber">${_lang.FORM.REGISTER.TENANT.DOCSUPPORT}</label>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.FORM.REGISTER.TENANT.DOCSUPPORTMANDATORY}</div>
							<label class="form-label">${_lang.FORM.REGISTER.TENANT.BIRTH}:</label>
							<div class="d-flex gap-2 mb-3">
								<select id="birthDay" name="birthDay" class="form-select" required></select>
								<select id="birthMonth" name="birthMonth" class="form-select" required></select>
								<select id="birthYear" name="birthYear" class="form-select" required></select>
							</div>
							<div class="position-relative mb-3">
								<label for="nationality" class="form-label">${_lang.FORM.REGISTER.TENANT.NATIONALITY}:</label>
								<select class="form-select select2" placeholder="${_lang.FORM.REGISTER.TENANT.NATIONALITY}" id="nationality" name="nationality"></select>
							</div>
							<div class="form-floating mb-3">
								<select class="form-select" placeholder="${_lang.FORM.REGISTER.TENANT.GENDER}" name="genre" id="genre">
									${$.map(_lang.FORM.REGISTER.TENANT.GENDERTYPES,(v,k)=>`<option value="${k}"${k==data.genre?` selected`:''}>${v}</option>`).join('')}
								</select>
								<label for="genre">${_lang.FORM.REGISTER.TENANT.GENDER}</label>
							</div>
							<!-- DIRECCION -->
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="adress[0]" name="adress[0]" maxlength="100" placeholder="${_lang.FORM.REGISTER.TENANT.ADRESS}" value="${data.adress[0]??''}" />
								<label for="adress[0]">${_lang.FORM.REGISTER.TENANT.ADRESS}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="adress[1]" name="adress[1]" maxlength="100" placeholder="${_lang.FORM.REGISTER.TENANT.ADITIONALADRESS}" value="${data.adress[1]??''}" />
								<label for="adress[1]">${_lang.FORM.REGISTER.TENANT.ADITIONALADRESS}</label>
							</div>
							<div class="position-relative">
								<label for="city" class="form-label">${_lang.FORM.REGISTER.TENANT.CITY}:</label>
								<select class="form-select select2" placeholder="${_lang.FORM.REGISTER.TENANT.CITY}" id="city" name="city"></select>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.FORM.REGISTER.TENANT.CITYMANDATORY}</div>
							<div class="form-floating">
								<input type="text" class="form-control" id="locality" name="locality" maxlength="100" placeholder="${_lang.FORM.REGISTER.TENANT.LOCALITY}" value="${data.locality}" />
								<label for="locality">${_lang.FORM.REGISTER.TENANT.LOCALITY}</label>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.FORM.REGISTER.TENANT.CITYNOMANDATORY}</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="zip" name="zip" maxlength="100" placeholder="${_lang.FORM.REGISTER.TENANT.ZIP}" value="${data.zip}" />
								<label for="zip">${_lang.FORM.REGISTER.TENANT.ZIP}</label>
							</div>
							<div class="position-relative mb-3">
								<label for="country" class="form-label">${_lang.FORM.REGISTER.TENANT.COUNTRY}:</label>
								<select class="form-select select2" placeholder="${_lang.FORM.REGISTER.TENANT.COUNTRY}" id="country" name="country"></select>
							</div>
							<!-- END DIRECCION -->
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="phone[0]" name="phone[0]" maxlength="20" placeholder="${_lang.FORM.REGISTER.TENANT.PHONE}" value="${data.phone[0]??''}" />
								<label for="phone[0]">${_lang.FORM.REGISTER.TENANT.PHONE}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="phone[1]" name="phone[1]" maxlength="20" placeholder="${_lang.FORM.REGISTER.TENANT.PHONE}" value="${data.phone[1]??''}" />
								<label for="phone[1]">${_lang.FORM.REGISTER.TENANT.PHONE}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="email" class="form-control" id="email" name="email" maxlength="250" placeholder="${_lang.FORM.REGISTER.TENANT.EMAIL}" value="${data.email}" />
								<label for="email">${_lang.FORM.REGISTER.TENANT.EMAIL}</label>
							</div>
							<div class="form-floating">
								<select class="form-select" placeholder="${_lang.FORM.REGISTER.TENANT.RELATION}" name="relation" id="relation">
									${$.map(_lang.FORM.REGISTER.TENANT.RELATIONTYPES,(v,k)=>`<option value="${k}"${k==data.relation?` selected`:''}>${v}</option>`).join('')}
								</select>
								<label for="relation">${_lang.FORM.REGISTER.TENANT.RELATION}</label>
							</div>
							<div class="text-muted" style="font-size: 0.75rem;">${_lang.FORM.REGISTER.TENANT.RELATIONMSG}</div>
						</form>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark submitTenant">${_lang.BTNS.SAVE}</button>
					</div>
				</div>
			</div>
		</div>
	`).appendTo('body');

	$bsModal = new bootstrap.Modal($modal);
	$bsModal.toggle();

	$modal.on('shown.bs.modal', () => {
		// Dni
		for (let d = 1; d <= 31; d++) {
			$modal.find('#birthDay').append(`<option value="${d}"${data.birthDay==d?' selected':''}>${d.toString().padStart(2, '0')}</option>`);
		}

		// Miesiące
		for (let m = 1; m <= 12; m++) {
			$modal.find('#birthMonth').append(`<option value="${m}"${data.birthMonth==m?' selected':''}>${m.toString().padStart(2, '0')}</option>`);
		}

		// Lata 1900 – dzisiaj
		const currentYear = new Date().getFullYear();
		for (let y = currentYear; y >= 1900; y--) {
			$modal.find('#birthYear').append(`<option value="${y}"${data.birthYear==y?' selected':''}>${y}</option>`);
		}
		$modal.find('#tenant #birth').datepicker('update', data.birth);
		// Selects
		$.getJSON(`${_u}lib/co-co.json`, d => {
			// Nationality
			$modal.find('#tenant select.select2#nationality').select2({
				language: _l,
				theme: 'bootstrap-5',
				dropdownParent: $modal,
				data: $.map(d,i=>{
					return {
						id: i.alpha3Code,
						text: i.nativeName,
						flag: i.flag,
						spelling: i.altSpellings,
						selected: data.nationality == i.alpha3Code
					};
				}),
				sorter: param => param.sort((a,b)=>a.text.localeCompare(b.text)),
				templateResult: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="d-flex justify-content-start align-items-center">
							<div class="col-2 text-center"><img class="img-fluid w-50" alt="${param.text}" src="${param.flag}" /></div>
							<div class="col-10 ps-1">${param.text}</div>
						</div>
					`);
				},
				templateSelection: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="d-flex justify-content-start align-items-center">
							<div class="col-2 text-center"><img class="img-fluid w-50" alt="${param.text}" src="${param.flag}" /></div>
							<div class="col-10 ps-1">${param.text}</div>
						</div>
					`);
				},
				matcher: (search,param) => {
					if(!param.id){return false;}
					if(!search.term){return param;}

					const term = search.term.toLowerCase();
					const text = param.text?.toLowerCase()??'';
					const id = param.id?.toLowerCase()??'';
					const spellings = (param.spelling||[]).map(s=>s.toLowerCase());

					if(text.includes(term) || id.includes(term) || spellings.some(s=>s.includes(term))){
						return param;
					}

					return null;
				}
			});
			// Country
			$modal.find('#tenant select.select2#country').select2({
				language: _l,
				theme: 'bootstrap-5',
				dropdownParent: $modal,
				data: $.map(d,i=>{
					return {
						id: i.alpha3Code,
						text: i.nativeName,
						flag: i.flag,
						spelling: i.altSpellings,
						selected: data.country == i.alpha3Code
					};
				}),
				sorter: param => param.sort((a,b)=>a.text.localeCompare(b.text)),
				templateResult: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="d-flex justify-content-start align-items-center">
							<div class="col-2 text-center"><img class="img-fluid w-50" alt="${param.text}" src="${param.flag}" /></div>
							<div class="col-10 ps-1">${param.text}</div>
						</div>
					`);
				},
				templateSelection: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="d-flex justify-content-start align-items-center">
							<div class="col-2 text-center"><img class="img-fluid w-50" alt="${param.text}" src="${param.flag}" /></div>
							<div class="col-10 ps-1">${param.text}</div>
						</div>
					`);
				},
				matcher: (search,param) => {
					if(!param.id){return false;}
					if(!search.term){return param;}

					const term = search.term.toLowerCase();
					const text = param.text?.toLowerCase()??'';
					const id = param.id?.toLowerCase()??'';
					const spellings = (param.spelling||[]).map(s=>s.toLowerCase());

					if(text.includes(term) || id.includes(term) || spellings.some(s=>s.includes(term))){
						return param;
					}

					return null;
				}
			});
		});
		// Cities
		$.getJSON(`${_u}lib/municipios.json`, d => {
			const entriesSorted = Object.entries(d).sort((a,b)=>a[1].localeCompare(b[1]));
			entriesSorted.unshift(["0",_lang.FORM.REGISTER.TENANT.NOCITY]);
			$modal.find('#tenant select.select2#city').select2({
				language: _l,
				theme: 'bootstrap-5',
				dropdownParent: $modal,
				data: entriesSorted.map(([k,v])=>({
					id: k,
					text: v,
					selected: k == data.city
				})),
				templateSelection: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="mt-2">${param.text}</div>
					`);
				}
			});
		});
	});

	$modal.find('.submitTenant').on('click', e => {
		const form = new FormData($modal.find('form#tenant')[0]);
		const json = {};

		for(const[key,value] of form.entries()){
			const arrayMatch = key.match(/^([^\[]+)\[(\d+)\]$/);
			if(arrayMatch){
				const baseKey = arrayMatch[1];
				const index = parseInt(arrayMatch[2]);

				if(!json[baseKey]) json[baseKey]=[];
				json[baseKey][index]=value;
			}else{
				json[key]=value;
			}
		}

		if ( !data.edit ) {

			modal.domuid.find('.addTenant').after(`
				<div class="d-flex justify-content-between align-items-center tenantBlock p-2 mt-3 rounded" style="background-color:var(--bs-gray-500);" data-id="${data.id}">
					<div class="col-5 text-center">${json.name} ${json.surname}</div>
					<div class="col-4 text-center">${_lang.FORM.REGISTER.TENANT.RELATIONTYPES[json.relation]}</div>
					<div class="col text-center">
						<button type="button" class="btn btn-sm btn-dark editTenant" data-id="${data.id}"><i class="fas fa-pen-to-square pe-none"></i></button>
						<button type="button" class="btn btn-sm btn-dark removeTenant" data-id="${data.id}"><i class="fas fa-trash-can pe-none"></i></button>
					</div>
				</div>
				<input type="hidden" name="tenant[${data.id}]" value='${JSON.stringify(json)}' />
			`);

		} else {

			modal.domuid.find(`.tenantBlock[data-id="${data.id}"] div:nth-child(1)`).text(`${json.name} ${json.surname}`);
			modal.domuid.find(`.tenantBlock[data-id="${data.id}"] div:nth-child(2)`).text(_lang.FORM.REGISTER.TENANT.RELATIONTYPES[json.relation]);
			modal.domuid.find(`input[name="tenant[${data.id}]"]`).val(JSON.stringify(json));

		}

		document.activeElement.blur();
		$bsModal.toggle();
		modal.bsModal.toggle();
	});

	$modal.on('hidden.bs.modal', () => {
		$modal.find('.submitTenant').off('click');
		$modal.find('#tenant #birth').datepicker('destroy');
		$modal.find('#tenant select.select2#nationality').select2('destroy');
		$modal.find('#tenant select.select2#country').select2('destroy');
		$modal.find('#tenant select.select2#city').select2('destroy');
		$modal.off('shown.bs.modal');
		$modal.off('hidden.bs.modal');
		$bsModal.dispose();
		$modal.remove();
		registerCreating = false;
	});

	$modal.on('click', '.btn-close', () => {
		document.activeElement.blur();
		$bsModal.toggle();
		modal.bsModal.toggle();
	});

}
function viewRegister(id){
	if (typeof id === 'undefined' || typeof id !== 'number') return false;

	$.post(`${_u}lib/_aj.php`,{t:'registerInfo',id}, d => {
		if (d.done) {
			var tenants = [];
			for(let [k,t] of Object.entries(d.tenants)) {
				tenants.push( `
					<div class="accordion-item">
						<h2 class="accordion-header" id="ten${k}">
							<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse${k}" aria-expanded="false" aria-controls="collapse${k}">
								${t.name} ${t.surname} ${t.secondsurname}
							</button>
						</h2>
						<div id="collapse${k}" class="accordion-collapse collapse" aria-labelledby="ten${k}" data-bs-parent="#accordion${k}">
							<div class="accordion-body">
								<ul class="list-group list-group-flush">
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.TTYPE}</div>
										<div class="col-6 text-end fw-bold">${_lang.FORM.REGISTER.TENANT.TYPES[t.type]}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.TRELATION}</div>
										<div class="col-6 text-end fw-bold">${_lang.FORM.REGISTER.TENANT.RELATIONTYPES[t.relation]}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.NATIONALITY}</div>
										<div class="col-6 text-end fw-bold">${t.nationality.name}<img src="${t.nationality.flag}" class="ms-3" style="height:20px;width:auto;border:1px solid #000;" /></div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${t.number}">
										<div class="col-6 text-start">${_lang.REGINFO.DOCUMENT}</div>
										<div class="col-6 text-end fw-bold">${t.number==''?'--':t.number}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${t.docNumber}">
										<div class="col-6 text-start">${_lang.REGINFO.DOCSUPPORT}</div>
										<div class="col-6 text-end fw-bold">${t.docNumber==''?'--':t.docNumber}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${t.adress[0]} ${t.adress[1]}, ${t.zip} ${t.locality==''?t.city:t.locality} ${t.country}">
										<div class="col-6 text-start">${_lang.REGINFO.ADDRESS}</div>
										<div class="col-6 text-end fw-bold">${t.adress[0]} ${t.adress[1]}, ${t.zip} ${t.locality==''?t.city:t.locality} ${t.country}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.BIRTH}</div>
										<div class="col-6 text-end fw-bold">${t.birth}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.GENRE}</div>
										<div class="col-6 text-end fw-bold">${_lang.FORM.REGISTER.TENANT.GENDERTYPES[t.genre]}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${t.email}">
										<div class="col-6 text-start">${_lang.REGINFO.EMAIL}</div>
										<div class="col-6 text-end fw-bold">${t.email==''?'--':t.email}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${t.phone[0]}">
										<div class="col-6 text-start">${_lang.REGINFO.TEL1}</div>
										<div class="col-6 text-end fw-bold">${t.phone[0]==''?'--':t.phone[0]}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${t.phone[1]}">
										<div class="col-6 text-start">${_lang.REGINFO.TEL2}</div>
										<div class="col-6 text-end fw-bold">${t.phone[1]==''?'--':t.phone[1]}</div>
									</li>
								</ul>
							</div>
						</div>
					</div>
				` );
			}
			$modal = $(`
				<div class="modal fade" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
					<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
						<div class="modal-content">
							<div class="modal-header">
								<div class="col-11">
									<h1 class="modal-title fs-5 d-flex justify-content-between align-items-center">
										<div class="col-9">${_lang.REGINFO.TITLE.format(`<b>${d.reservation}</b>`,d.apartment)}</div>
										<span class="col badge bg-${d.data.entry==''?'danger':'success'}" style="font-size:0.75rem;">${d.data.entry==''?_lang.REGINFO.NOREGISTERED:_lang.REGINFO.REGISTERED}</span>
									</h1>
								</div>
								<button type="button" class="btn-close col" data-bs-dismiss="modal" aria-label="Close"></button>
							</div>
							<div class="modal-body">
								<ul class="list-group list-group-flush">
									${d.data.link!=''&&d.data.entry==''?`
									<li class="list-group-item list-group-item-action text-center copyclip" data-url="${_u}form/${d.data.link}">
										${_u}form/${d.data.link}
									</li>`:''}
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${d.reservation}">
										<div class="col-6 text-start">${_lang.REGINFO.RESERVATION}</div>
										<div class="col-6 text-end fw-bold">${d.reservation}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.APARTMENT}</div>
										<div class="col-6 text-end fw-bold">${d.apartment}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.RESDATE}</div>
										<div class="col-6 text-end fw-bold">${d.checkin}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.START}</div>
										<div class="col-6 text-end fw-bold">${d.start}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.END}</div>
										<div class="col-6 text-end fw-bold">${d.end}</div>
									</li>
								</ul>

								<h1 class="fs-5 bg-dark text-white text-center text-uppercase p-2 m-0 rounded">${_lang.REGINFO.SESINFO}</h1>

								${d.data.entry==''?`
									<div class="w-100 text-center text-danger py-2">${_lang.REGINFO.NOREGISTERED}</div>
								`:`
									<ul class="list-group list-group-flush">
										<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
											<div class="col-6 text-start">${_lang.REGINFO.SESDATE}</div>
											<div class="col-6 text-end fw-bold">${d.data.registered}</div>
										</li>
										<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${d.data.entry}">
											<div class="col-6 text-start">${_lang.REGINFO.SESID}</div>
											<div class="col-6 text-end fw-bold">${d.data.entry}</div>
										</li>
									</ul>
								`}

								<h1 class="fs-5 bg-dark text-white text-center text-uppercase p-2 m-0 rounded">${_lang.REGINFO.INFO}</h1>

								<ul class="list-group list-group-flush">
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.PAYMENTTYPE}</div>
										<div class="col-6 text-end fw-bold">${_lang.FORM.REGISTER.PAYMENTSTYPES[d.data.paymentType]}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.PAYMENTDATE}</div>
										<div class="col-6 text-end fw-bold">${d.data.paycardDate}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${d.data.cardOwner}">
										<div class="col-6 text-start">${_lang.REGINFO.OWNER}</div>
										<div class="col-6 text-end fw-bold">${d.data.cardOwner==''?'--':d.data.cardOwner}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center copyclip" data-url="${d.data.paymentValue}">
										<div class="col-6 text-start">${_lang.REGINFO.PAYVALUE}</div>
										<div class="col-6 text-end fw-bold">${d.data.paymentValue==''?'--':d.data.paymentValue}</div>
									</li>
									<li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
										<div class="col-6 text-start">${_lang.REGINFO.EXPIRY}</div>
										<div class="col-6 text-end fw-bold">${d.data.cardExpire==''?'--':d.data.cardExpire}</div>
									</li>
								</ul>

								<h1 class="fs-5 bg-dark text-white text-center text-uppercase p-2 m-0 rounded">${_lang.REGINFO.TENANTS}</h1>

								${d.tenants.length>0?`
									<div class="accordion" id="accTenants">${tenants.join('')}</div>
								`:`
									<div class="w-100 text-center text-danger py-2">${_lang.REGINFO.NOTENANTS}</div>
								`}
							</div>
						</div>
					</div>
				</div>
			`).appendTo('body');

			$bsModal = new bootstrap.Modal($modal);
			$bsModal.show();

			$modal.one('hidden.bs.modal', () => {
				$modal.off('hidden.bs.modal');
				$bsModal.dispose();
				$modal.remove();
			});
		}
	}, 'json');
}
function inputCardExpire(event){
	let value = event.target.value.replace(/\D/g,'');
	if(value.length>=3){
		value = value.slice(0,2)+'/'+value.slice(2,6);
	}
	event.target.value = value.slice(0,7);
}
function blurCardExpire(event){
	const regex = /^(0[1-9]|1[0-2])\/\d{4}$/;
	if(!regex.test(event.target.value)&&event.target.value!=''){
		event.target.focus();
	}
}
if (!String.prototype.format) {
	String.prototype.format = function () {
		var args = arguments;
		return this.replace(/{(\d+)}/g, function (match, number) {
			return typeof args[number] != 'undefined'
				? args[number]
				: match
				;
		});
	};
}
function registerView(data) {

	if (!getCookie('login')) { return false; }

	var tenants = '';

	for (var i of data.tenants) {
		tenants += `
			<ul class="list-group list-group-horizontal my-2">
				<li class="list-group-item col-7">${i.name} ${i.surname}</li>
				<li class="list-group-item col">${i.doc}</li>
			</ul>
		`;
	}

	modal.modal = $('body').append(`
		<div class="modal fade" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
			<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
				<div class="modal-content">
					<div class="modal-header">
						<h1 class="modal-title fs-5"><b>${data.ref}</b> - ${data.reservation}</h1>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<p>Check-In realizado: <span class="fw-bold${data.checkin == '' ? ' text-danger' : ' text-success'}">${data.checkin == '' ? _lang.MISC.NO : data.checkin}</span></p>
						<p>${_lang.FORMATS.RESERVE.format(data.start, data.end)}</p>
						<h1 class="fs-5 bg-dark text-white p-2 rounded mb-3">${_lang.LABELS.TENANT}</h1>
						<ul class="list-group list-group-horizontal">
							<li class="list-group-item col-5 text-truncate">${_lang.LABELS.PHONE}</li>
							<a class="list-group-item list-group-item-action" href="https://wa.me/${data.data.phone.code}${data.data.phone.number}" target="_blank">+${data.data.phone.code} ${data.data.phone.number}</a>
						</ul>
						<ul class="list-group list-group-horizontal mt-2">
							<li class="list-group-item col-5 text-truncate">${_lang.LABELS.EMAIL}</li>
							<a class="list-group-item list-group-item-action" href="mailto:${data.data.email}" target="_self">${data.data.email}</a>
						</ul>
						<ul class="list-group list-group-horizontal mt-2 mb-3">
							<li class="list-group-item col-5 text-truncate">${_lang.LABELS.ADRESS}</li>
							<li class="list-group-item col">${data.data.address}</li>
						</ul>
						<h1 class="fs-5 bg-dark text-white p-2 rounded mb-3">${_lang.LABELS.TENANTREGISTERED}</h1>
						${tenants}
					</div>
				</div>
			</div>
		</div>
	` );

	modal.domuid = $(document).find('.modal');
	modal.bsModal = new bootstrap.Modal(modal.domuid);
	modal.bsModal.toggle();
	modal.domuid.on('shown.bs.modal', () => { });
	modal.domuid.on('hidden.bs.modal', () => {
		modal.domuid.off('shown.bs.modal');
		modal.domuid.off('hidden.bs.modal');
		modal.bsModal.dispose();
		modal.domuid.remove();
		modal.bsModal = null;
		modal.domuid = null;
		modal.modal = null;
	});

}
function checkLogin() {
	$.post(`${_u}lib/_aj.php`, { t: 'checkLogin' }, d => {
		if (!d.done) { location.reload(); } else { setTimeout('checkLogin()', 10000); }
	}, 'json');
}

function buildPagination ( pages, page, cssClass ) {

	pages = parseInt ( pages );
	page = parseInt ( page );

	var html = `
		<div class="d-flex flex-nowrap justify-content-start align-items-center pagination ${cssClass}">
	`;

	if ( pages > 1 ) {
		if ( page > 1 ) {
			html += `<button type="button" class="btn mx-2" data-page="${(page>pages?pages:page) - 1}"><i class="fas fa-chevron-left pe-none"></i></button>`;
		}
		html += `<input type="number" value="${page>pages?pages:page}" class="form-control text-center" min="1" max="${pages}" style="width:60px;" onkeypress="return onlyNumb(event);" /><span class="ms-2">/ ${pages}</span>`;
		if ( page < pages ) {
			html += `<button type="button" class="btn mx-2" data-page="${(page>pages?pages:page) + 1}"><i class="fas fa-chevron-right pe-none"></i></button>`
		}
	}

	html += `
		</div>
	`;

	return $ ( html );

}

$(document).ready(() => {

	if (getCookie('login')) { checkLogin(); }
	apartList(pagination.apart);
	registerList(pagination.register);

	$(document).on('click','.pagination.apartPag button:not(.disabled)',e => {
		$(e.target).prop('disabled',true);
		apartList($(e.target).data('page'));
	});

	$(document).on('change','.pagination.apartPag input',e => {
		if ($(e.target).val()!=pagination.apart) {
			$(e.target).prop('disabled',true);
			apartList($(e.target).val());
		}
	});

	$(document).on('click','#removeFilterApart',() => {
		filters.apart = {
			ref: '',
			name: '',
			sesid: ''
		};
		$('#filter-apartments input[name="ref"]').val('');
		$('#filter-apartments input[name="name"]').val('');
		$('#filter-apartments input[name="sesid"]').val('');
		apartList(0);
	});

	$(document).on('click','.pagination.registerPag button:not(.disabled)',e => {
		$(e.target).prop('disabled',true);
		registerList($(e.target).data('page'));
	});

	$(document).on('change','.pagination.registerPag input',e => {
		if ($(e.target).val()!=pagination.register) {
			$(e.target).prop('disabled',true);
			registerList($(e.target).val());
		}
	});


	$(document).on('click','#removeFilterRegister',() => {
		filters.register = {
			booking: '',
			ref: '',
			checkin: '',
			checkout: '',
			tenant: ''
		};
		$('#filter-registers input[name="booking"]').val('');
		$('#filter-registers input[name="ref"]').val('');
		$('#filter-registers input[name="checkin"]').val('');
		$('#filter-registers input[name="checkout"]').val('');
		$('#filter-registers input[name="tenant"]').val('');
		registerList(0);
	});

	$(document).find('#filter-registers input[name="checkin"], #filter-registers input[name="checkout"]').datepicker({
		todayHighlight: true,
		autoclose: true,
		format: {
			toDisplay: d => {
				var fd = new Date(d);
				return `${fd.getDate().toString().padStart(2,'0')}/${(fd.getMonth()+1).toString().padStart(2,'0')}/${fd.getFullYear()}`;
			},
			toValue: d => d
		},
		language: _l
	});

	if (getCookie('login')) {}

	$("#login").on("submit", (e) => {
		e.preventDefault;
		$.post(`${_u}lib/_aj.php`, $(e.target).serialize(), d => {
			if (d.done) {
				location.reload();
			} else {
				$(e.target)[0].reset();
			}
		}, 'json');
		return false;
	});

	$(document).on('change', '.apartActive', e => {
		var val = $(e.target).val();
		var uid = $(e.target).data('id');
		$.post(`${_u}lib/_aj.php`, { t: 'toggleActive', v: val, uid }, () => { }, 'json');
	});

	$(document).on('click', '.apartEdit', e => {
		var uid = $(e.target).data('id');
		$.post(`${_u}lib/_aj.php`, { t: 'editApart', uid }, d => {
			if (d.done) {
				addApartment(d.data);
			}
		}, 'json');
	});

	$(document).on('click', '.addApart', () => {
		if ( limits ('apart') ) {
			addApartment(null);
		}
	});

	$(document).on('click', '.submitApart', () => {
		if ( limits ('apart') ) {
			$.post(`${_u}lib/_aj.php`, $('#formApart').serialize(), (d) => {
				if (d.done) {
					modal.bsModal.hide();
					apartList(pagination.apart);
				}
			}, 'json');
		}
	});

	$(document).on('click', '.apartRemove', e => {
		var uid = $(e.target).data('id');
		$.post(`${_u}lib/_aj.php`, { t: 'removeApart', uid }, d => {
			if (d.done) {
				apartList(pagination.apart);
				loadMap();
			}
		}, 'json');
	});

	$(document).on('click', '.registerEdit', e => {
		var uid = $(e.target).data('id');
		$.post(`${_u}lib/_aj.php`, { t: 'editRegister', uid }, d => {
			if (d.done) {
				addRegister(d.data);
			}
		}, 'json');
	});

	$(document).on('click', '.duplicateRegister', e => {
		var uid = $(e.target).data('id');
		$.post(`${_u}lib/_aj.php`, {t:'editRegister', uid}, d => {
			if (d.done) {
				d.data.type = 'addRegister';
				d.data.reservation = '';
				addRegister(d.data);
			}
		}, 'json');
	});

	$(document).on('click', '.registerRemove', e => {
		var uid = $(e.target).data('id');
		$.post(`${_u}lib/_aj.php`, { t: 'removeRegister', uid }, d => {
			if (d.done) {
				registerList(pagination.register);
			}
		}, 'json');
	});

	$(document).on('click', '.addRegister', () => {
		if ( limits ('reg') ) {
			addRegister(null);
		}
	});

	$(document).on('click', '.submitRegister', () => {
		if ( limits ('reg') ) {
			$.post(`${_u}lib/_aj.php`, $('#formRegister').serialize(), d => {
				if (d.done) {
					modal.bsModal.hide();
					registerList(pagination.register);
				}
			}, 'json');
			return false;
		}
	});

	$(document).on('click', '.logout', () => {
		$.post(`${_u}lib/_aj.php`, { t: 'logout' }, d => {
			if (d.done) {
				location.reload();
			}
		}, 'json');
	});

	$(document).on('click', '.registerVisit', e => {

		const uid = $(e.target).data('id');

		$modal = $(`
			<div class="modal fade" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
				<div class="modal-dialog modal-sm modal-dialog-centered modal-dialog-scrollable">
					<div class="modal-content">
						<div class="modal-header">
							<h1 class="modal-title fs-5">${$(e.target).data('value')}</h1>
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<div class="modal-body text-center">
							<h4>${_lang.FORM.REGISTER.MODAL.TITLE}</h4>
							<p>${_lang.FORM.REGISTER.MODAL.SUBTITLE}</p>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-dark w-100 sendReservation">${_lang.BTNS.ACCEPT}</button>
						</div>
					</div>
				</div>
			</div>
		`).appendTo('body');

		$bsModal = new bootstrap.Modal($modal);
		$bsModal.toggle();

		$modal.on('shown.bs.modal', () => {});

		$modal.on('hidden.bs.modal', () => {
			$modal.find('.sendReservation').off('click');
			$modal.off('shown.bs.modal');
			$modal.off('hidden.bs.modal');
			$bsModal.dispose();
			$modal.remove();
		});

		$modal.find('.sendReservation').on('click', b => {
			$(b.target).prop('disabled',true);
			$.post(`${_u}lib/_aj.php`,{t:'sendTenant',uid},d => {
				if(d.done){
					$modal.find('.modal-body').html(`<p>${_lang.FORM.REGISTER.MODAL.SUCCESS}</p>`);
					registerList(pagination.register);
				}else{
					$modal.find('.modal-body').html(`<p>${d.msg}</p>`);
				}
				$modal.find('.modal-footer').addClass('d-none');
			},'json');
		});

	});

	$(document).on('click', '.registerView', e => viewRegister($(e.target).data('id')) );

	$(document).on('click', '.copyclip', e => {
		var url = $(e.target).data('url');
		if ( typeof url === 'undefined' ) {
			url = $(e.currentTarget).data('url');
		}
		if(url=='') return false;
		navigator.clipboard.writeText(url);
		var domCopy = $(document).find('.msgCopy');
		if (domCopy.length < 1) {
			$('body').append(`<div class="position-fixed bg-light text-dark p-4 rounded shadow msgCopy" style="bottom: 40px;right:40px;display:none;z-index:9999;">${_lang.MISC.COPY}</div>`);
			domCopy = $(document).find('.msgCopy');
			domCopy.fadeIn(300);
			setTimeout(() => {
				domCopy.fadeOut(300).delay(400, () => domCopy.remove());
			}, 4000);
		}
	});

});