<?php

require realpath ( __DIR__ . '/load.php' );
$_f -> setLang ( $_COOKIE ['lang'] ?? null );

$_s = new SQLite3(DIR . md5('SES') . '.db', SQLITE3_OPEN_READWRITE);

if (isset($_GET['file']) && isset($_COOKIE['login'])) {

	$file = $_s->openBlob('images', 'img', $_GET['file']);
	$mime = $_s->query("SELECT `mime` FROM `images` WHERE `id` = '{$_GET['file']}' AND `deleted` = '0'")->fetchArray(1);
	header("Content-Type: {$mime['mime']}");
	echo stream_get_contents($file);
	fclose($file);
	$_s->close();
	exit();

}

if (!isset($_POST['t'])) {
	$_s->close();
	exit();
}



switch ($_POST['t']) {

	case 'checkLogin':
		$_f->_json(['done' => isset($_COOKIE['login'])]);
		break;

	case 'getLangs':

		if (!isset($_COOKIE['login'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$dir = scandir(__DIR__ . '/../lang/');
		unset($dir[0], $dir[1]);
		$dir = array_values($dir);
		$_f->_json($dir);

		break;

	case 'getRefs':

		if (!isset($_COOKIE['login'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$check = $_s->query("SELECT COUNT(*) AS `total` FROM `apartment` WHERE `active` = '1'")->fetchArray(1);

		if ($check['total'] > 0) {

			$check = $_s->query("SELECT * FROM `apartment` WHERE `active` = '1'");

			$ret = [];

			while ($r = $check->fetchArray(1)) {

				$ret[] = [
					'ref' => $r['ref'],
					'name' => $r['name']
				];

			}

			$_f->_json(['done' => 1, 'data' => $ret]);

		} else {

			$_f->_json(['done' => 0]);

		}

		break;

	case 'login':

		if ( empty ( $_f->getConfig('user') ) || empty ( $_f->getConfig('pass') ) ) {
			$_f->_json(['done'=>0]);
			break;
		}

		if (!isset($_POST['username']) || !isset($_POST['password'])) {
			$_f->_json(['done'=>0]);
			break;
		}

		$user = trim($_POST['username']);
		$pass = trim($_POST['password']);

		if ($_f->getConfig('user') != $user) {
			$_f->_json(['done'=>0]);
			break;
		}

		if ( !password_verify($pass,$_f->getConfig('pass')) ) {
			$_f->_json(['done'=>0]);
			exit();
		}

		setcookie('login', true, time() + 3600 * 4, "/");
		$_f->_json(['done'=>1]);

		break;

	case 'logout':

		if (isset($_COOKIE['login'])) {

			unset($_COOKIE['login']);
			setcookie('login', false, -1, "/");
			$_f->_json(['done' => 1]);

		}

		break;

	case 'newuser':

		if ($_f->getConfig('name')=='') {
			$_f->setConfig('name',$_POST['name']);
		}
		if ($_f->getConfig('user')=='') {
			$_f->setConfig('user',mb_convert_case($_POST['user'],MB_CASE_LOWER,'UTF-8'));
		}
		if ($_f->getConfig('pass')=='') {
			$_f->setConfig('pass',$_POST['pass'][1]);
		}
		if ($_f->getConfig('redirect')=='') {
			$_f->setConfig('redirect',$_POST['redirect']);
		}

		$_f->_json(['done'=>1]);

		break;

	case 'apart-list':

		if (!isset($_COOKIE['login'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$filters = [];

		if (!empty($_POST['filter']['ref'])) {
			$filters [] = "`ref` LIKE '%{$_POST['filter']['ref']}%'";
		}

		if (!empty($_POST['filter']['name'])) {
			$filters [] = "`name` LIKE '%{$_POST['filter']['name']}%'";
		}

		if (!empty($_POST['filter']['sesid'])) {
			$filters [] = "`sesid` LIKE '%{$_POST['filter']['sesid']}%'";
		}

		$query = "SELECT COUNT(*) AS `total` FROM `apartment`" . (count($filters)?" WHERE " . implode(' AND ', $filters):'');
		$check = $_s->query($query)->fetchArray(1);
		$total = $check ['total'];

		if ($total > 0) {

			$query = "SELECT * FROM `apartment`" . (count($filters)?" WHERE " . implode(' AND ', $filters):'') . " ORDER BY `id` DESC";
			$limit = $_f -> _pagination($total,10,$_POST['p']);
			$query .= " LIMIT {$limit['limit']['limit']} OFFSET {$limit['limit']['start']}";

			$check = $_s->query($query);

			$ret = [];

			while ($r = $check->fetchArray(1)) {

				$ret[] = [
					'id' => $r['id'],
					'ref' => $r['ref'],
					'name' => $r['name'],
					'sesid' => $r['sesid'],
					'active' => $r['active']
				];

			}

			$_f->_json(['done' => 1, 'data' => $ret, 'total' => $total, 'page' => $limit['page'], 'pages' => $limit['pages'], 'next' => $limit['next']]);

		} else {

			$_f->_json(['done' => 0]);

		}

		break;

	case 'editApart':


		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$check = $_s->query("SELECT *, COUNT(*) AS `total` FROM `apartment` WHERE `id` = '{$_POST['uid']}'")->fetchArray(1);

		if ($check['total'] == 1) {

			$data = [
				'id' => $check['id'],
				'title' => $_f->translate ( "FORM.APARTMENTS.EDIT" ) . " {$check['name']} ({$check['ref']})",
				'type' => 'updateApart',
				'ref' => $check['ref'],
				'name' => $check['name'],
				'sesid' => $check['sesid']
			];

			$_f->_json(['done' => 1, 'data' => $data]);

		}

		break;

	case 'addApart':

		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		foreach ($_POST as $k => $v) {
			if (is_array($_POST[$k])) {
				foreach ($v as $k2 => $v2) {
					if (is_array($v[$k2])) {
						foreach ($v2 as $k3 => $v3) {
							$_POST[$k][$k2][$k3] = $_s->escapeString($v3);
						}
					} else {
						$_POST[$k][$k2] = $_s->escapeString($v2);
					}
				}
			} else {
				$_POST[$k] = $_s->escapeString($v);
			}
		}

		$data = [
			'ref' => $_POST['ref'],
			'name' => $_POST['name'],
			'sesid' => $_POST ['sesid']
		];

		$_s->query("INSERT INTO `apartment` (`ref`,`name`,`sesid`,`active`) VALUES (
			'{$data['ref']}',
			'{$data['name']}',
			'{$data['sesid']}',
			'1'
		)");

		$_f->_json(['done' => 1]);

		break;

	case 'updateApart':

		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		foreach ($_POST as $k => $v) {
			if (is_array($_POST[$k])) {
				foreach ($v as $k2 => $v2) {
					if (is_array($v[$k2])) {
						foreach ($v2 as $k3 => $v3) {
							$_POST[$k][$k2][$k3] = !empty($_POST[$k][$k2][$k3]) ? $_s->escapeString($v3) : "";
						}
					} else {
						$_POST[$k][$k2] = !empty($_POST[$k][$k2]) ? $_s->escapeString($v2) : "";
					}
				}
			} else {
				$_POST[$k] = !empty($_POST[$k]) ? $_s->escapeString($v) : "";
			}
		}

		$data = [
			'ref' => $_POST['ref'],
			'name' => $_POST['name'],
			'sesid' => $_POST ['sesid']
		];

		$_s->query("UPDATE `apartment` SET
				`ref` = '{$data['ref']}',
				`name` = '{$data['name']}',
				`sesid` = '{$data['sesid']}' WHERE `id` = '{$_POST['uid']}'");

		$_f->_json(['done' => 1]);

		break;

	case 'removeApart':

		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$_s->query("DELETE FROM `apartment` WHERE `id` = '{$_POST['uid']}'");

		$_f->_json(['done' => 1]);

		break;

	case 'toggleActive':

		if (!isset($_COOKIE['login'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$check = $_s->query("SELECT COUNT(*) AS `total` FROM `apartment` WHERE `id` = '{$_POST['uid']}'")->fetchArray(1);

		if ($check['total'] == 1) {

			$_s->query("UPDATE `apartment` SET `active` = '{$_POST['v']}' WHERE `id` = '{$_POST['uid']}'");
			$_f->_json(['done' => 1]);

		}

		break;

	case 'register-list':

		if (!isset($_COOKIE['login'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$filters = [];

		if (!empty($_POST['filter']['booking'])) {
			$filters [] = "`reservation` LIKE '%{$_POST['filter']['booking']}%'";
		}

		if (!empty($_POST['filter']['ref'])) {
			$filters [] = "`ref` LIKE '%{$_POST['filter']['ref']}%'";
		}

		if (!empty($_POST['filter']['checkin'])) {
			$date = explode('/',$_POST['filter']['checkin']);
			$date = strtotime("{$date[2]}-{$date[1]}-{$date[0]}");
			$filters [] = "(`start` >= '{$date}' AND `start` <= '" . ($date + (60 * 60 * 24)) . "')";
		}

		if (!empty($_POST['filter']['checkout'])) {
			$date = explode('/',$_POST['filter']['checkout']);
			$date = strtotime("{$date[2]}-{$date[1]}-{$date[0]}");
			$filters [] = "(`end` >= '{$date}' AND `end` <= '" . ($date + (60 * 60 * 24)) . "')";
		}

		if (!empty($_POST['filter']['tenant'])) {
			$filters [] = "(`tenants` LIKE '%\"name\":\"%{$_POST['filter']['tenant']}%\"%' OR `tenants` LIKE '%\"surname\":\"%{$_POST['filter']['tenant']}%\"%' OR `tenants` LIKE '%\"secondsurname\":\"%{$_POST['filter']['tenant']}%\"' OR `tenants` LIKE '%\"number\":\"{$_POST['filter']['tenant']}%\"%')";
		}

		$query = "SELECT COUNT(*) AS `total` FROM `register`" . (count($filters)?" WHERE " . implode(' AND ', $filters):'');
		$check = $_s->query($query)->fetchArray(1);
		$total = $check ['total'];

		$old = [];
		$ret = [];

		if ($total > 0) {

			$query = "SELECT * FROM `register`" . (count($filters)?" WHERE " . implode(' AND ', $filters):'') . " ORDER BY `start` DESC";
			$limit = $_f -> _pagination($total,10,$_POST['p']);
			$query .= " LIMIT {$limit['limit']['limit']} OFFSET {$limit['limit']['start']}";

			$check = $_s->query($query);

			$sended = [];

			while ($r = $check->fetchArray(1)) {

				if ( $r ['start'] < time () ) {
					$old [] = $r;
					continue;
				}

				$data = json_decode($r['data'],1);

				$ret[] = [
					'id' => $r['id'],
					'reservation' => $r['reservation'],
					'ref' => $r['ref'],
					'days' => [
						'start' => mb_substr($_f->translate("MISC.DATE.DAY.".date('w', $r['start'])), 0, 3, 'UTF-8') . " - " . mb_substr($_f->translate("MISC.DATE.MONTH.".date('n', $r['start']) - 1), 0, 3, 'UTF-8'),
						'end' => mb_substr($_f->translate("MISC.DATE.DAY.".date('w', $r['end'])), 0, 3, 'UTF-8') . " - " . mb_substr($_f->translate("MISC.DATE.MONTH.".date('n', $r['end']) - 1), 0, 3, 'UTF-8')
					],
					'start' => date('d / m / Y', $r['start']),
					'end' => date('d / m / Y', $r['end']),
					'sended' => !empty($data['entry']??'--'),
					'link' => isset($data['link'])?"{$_http}form/{$data['link']}-{$r['ref']}":''
				];

			}

			foreach ( $old as $v ) {

				$data = json_decode($v['data'],1);

				$ret[] = [
					'id' => $v['id'],
					'reservation' => $v['reservation'],
					'ref' => $v['ref'],
					'days' => [
						'start' => mb_substr($_f->translate("MISC.DATE.DAY.".date('w', $v['start'])), 0, 3, 'UTF-8') . " - " . mb_substr($_f->translate("MISC.DATE.MONTH.".date('n', $v['start']) - 1), 0, 3, 'UTF-8'),
						'end' => mb_substr($_f->translate("MISC.DATE.DAY.".date('w', $v['end'])), 0, 3, 'UTF-8') . " - " . mb_substr($_f->translate("MISC.DATE.MONTH.".date('n', $v['end']) - 1), 0, 3, 'UTF-8')
					],
					'start' => date('d / m / Y', $v['start']),
					'end' => date('d / m / Y', $v['end']),
					'sended' => !empty($data['entry']??'--'),
					'link' => isset($data['link'])?"{$_http}form/{$data['link']}-{$v['ref']}":''
				];

			}

		}

		if ( !count ( $ret ) ) {
			$_f->_json ( ['done' => 0] );
		} else {
			$_f->_json ( ['done' => 1, 'data' => $ret, 'total' => $total, 'page' => $limit['page'], 'pages' => $limit['pages'], 'next' => $limit['next']] );
		}

		break;

	case 'addRegister':

		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$dates = explode(',', $_POST['date-values']);

		if ( isset ( $_POST ['tenant'] ) ) {
			foreach ( $_POST ['tenant'] as $k => $v ) {

				$_POST ['tenant'] [$k] = json_decode ( $v, 1 );

			}
		} else {
			$_POST ['tenant'] = [];
		}

		$data = [
			'ref'					=> $_POST ['ref'],
			'reservation'			=> mb_convert_case($_POST['reservation'],MB_CASE_UPPER,'UTF-8'),
			'checkin'				=> (int) $dates[2],
			'start'					=> (int) $dates[0],
			'end'					=> (int) $dates[1],
			'data'					=> [
				'paymentType'		=> $_POST ['paymentType'],
				'paycardDate'		=> (int) $dates[3],
				'paymentValue'		=> $_POST ['paymentValue'],
				'cardOwner'			=> mb_convert_case($_POST['cardOwner'],MB_CASE_UPPER,'UTF-8'),
				'cardExpire'		=> $_POST['cardExpire'],
				'registered'		=> (int) 0,
				'entry'				=> '',
				'link'				=> ''
			],
			'tenants'				=> []
		];

		do {
			$token = $_f->token();
			$check = $_s->query("SELECT COUNT(*) AS `total` FROM `register` WHERE `data` LIKE '%\"{$token}\"%'" )->fetchArray(1);
			if($check['total']==0){
				$data['data']['link'] = $token;
			}
		} while ( empty($data['data']['link']) );

		foreach ( $_POST ['tenant'] as $k => $v ) {
			$data ['tenants'] [] = $v;
		}

		$data ['data'] = json_encode ( $data ['data'], JSON_UNESCAPED_UNICODE );
		$data ['tenants'] = json_encode ( $data ['tenants'], JSON_UNESCAPED_UNICODE );

		$check = $_s->query("SELECT *, COUNT(*) AS `total` FROM `register` WHERE `reservation` = '" . mb_convert_case($_POST['reservation'], MB_CASE_UPPER, 'UTF-8') . "'")->fetchArray(1);

		if ($check['total'] == 0) {

			$_s->query("INSERT INTO `register` (`ref`,`checkin`,`reservation`,`start`,`end`,`data`,`tenants`) VALUES (
				'".$_s->escapeString($data['ref'])."',
				'".$_s->escapeString($data['checkin'])."',
				'".$_s->escapeString($data['reservation'])."',
				'".$_s->escapeString($data['start'])."',
				'".$_s->escapeString($data['end'])."',
				'".$_s->escapeString($data['data'])."',
				'".$_s->escapeString($data['tenants'])."'
			)");

		}

		$_f->_json(['done' => 1]);

		break;

	case 'editRegister':

		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$check = $_s->query("SELECT *, COUNT(*) AS `total` FROM `register` WHERE `id` = '".$_s->escapeString($_POST['uid'])."'")->fetchArray(1);

		if ($check['total'] == 1) {
			$data = json_decode($check['data'],1);
			$tenants = [];
			foreach(json_decode($check['tenants'],1) as $k => $v) {
				$tenants [] = json_encode($v,JSON_UNESCAPED_UNICODE);
			}
			$_f->_json([
				'done' => 1,
				'data' => [
					'id' => $check['id'],
					'title' => $_f->translate ( "FORM.REGISTER.EDIT" ) . " {$check['reservation']}",
					'type' => 'updateRegister',
					'reservation' => $check['reservation'],
					'contractDate' => isset($check['checkin'])&&!empty($check['checkin'])?date('r', $check['checkin']??0):'',
					'ref' => $check['ref'],
					'start' => date('r', $check['start']),
					'end' => date('r', $check['end']),
					'paycardDate' => date('r', $data['paycardDate']),
					'paymentType' => $data['paymentType'],
					'paymentValue' => $data['paymentValue'],
					'cardOwner' => $data['cardOwner'],
					'cardExpire' => $data['cardExpire'],
					'tenants' => $tenants
				]
			]);
		}

		break;

	case 'updateRegister':

		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$check = $_s->query("SELECT `data`, COUNT(*) AS `total` FROM `register` WHERE `id` = '".$_s->escapeString($_POST['uid'])."'")->fetchArray(1);

		if($check['total']==0){
			$_f->_json(['done' => 0]);
			break;
		}

		$dates = explode(',', $_POST['date-values']);

		if ( isset ( $_POST ['tenant'] ) ) {

			foreach ( $_POST ['tenant'] as $k => $v ) {

				$v = json_decode ( $v, 1 );
				$v ['name'] = mb_convert_case ( $v ['name'], MB_CASE_TITLE, 'UTF-8' );
				$v ['surname'] = mb_convert_case ( $v ['surname'], MB_CASE_TITLE, 'UTF-8' );
				$v ['secondsurname'] = mb_convert_case ( $v ['secondsurname'], MB_CASE_TITLE, 'UTF-8' );
				$v ['adress'] [0] = mb_convert_case ( $v ['adress'] [0], MB_CASE_TITLE, 'UTF-8' );
				$v ['adress'] [1] = mb_convert_case ( $v ['adress'] [1], MB_CASE_TITLE, 'UTF-8' );
				$v ['locality'] = mb_convert_case ( $v ['locality'], MB_CASE_TITLE, 'UTF-8' );
				$v ['email'] = strtolower ( $v ['email'] );

				$_POST ['tenant'] [$k] = $v;


			}

		} else {

			$_POST ['tenant'] = [];

		}

		$oldData = json_decode($check['data'],1);

		$data = [
			'ref'					=> $_POST ['ref'],
			'reservation'			=> mb_convert_case($_POST['reservation'],MB_CASE_UPPER,'UTF-8'),
			'checkin'				=> (int) $dates[2],
			'start'					=> (int) $dates[0],
			'end'					=> (int) $dates[1],
			'data'					=> [
				'paymentType'		=> $_POST ['paymentType'],
				'paycardDate'		=> (int) $dates[3],
				'paymentValue'		=> $_POST ['paymentValue'],
				'cardOwner'			=> mb_convert_case($_POST['cardOwner'],MB_CASE_UPPER,'UTF-8'),
				'cardExpire'		=> $_POST['cardExpire'],
				'registered'		=> (int) 0,
				'entry'				=> $oldData['entry'],
				'link'				=> $oldData['link']
			],
			'tenants'				=> []
		];

		foreach ( $_POST ['tenant'] as $k => $v ) {
			$data ['tenants'] [] = $v;
		}

		$data ['data'] = json_encode ( $data ['data'], JSON_UNESCAPED_UNICODE );
		$data ['tenants'] = json_encode ( $data ['tenants'], JSON_UNESCAPED_UNICODE );

		$_s->query("UPDATE `register` SET `ref` = '".$_s->escapeString($data['ref'])."',
									 `checkin` = '".$_s->escapeString($data['checkin'])."',
									 `reservation` = '".$_s->escapeString($data['reservation'])."',
									 `start` = '".$_s->escapeString($data['start'])."',
									 `end` = '".$_s->escapeString($data['end'])."',
									 `data` = '".$_s->escapeString($data['data'])."',
									 `tenants` = '".$_s->escapeString($data['tenants'])."'
					WHERE `id` = '".$_s->escapeString($_POST['uid'])."'");

		$_f->_json(['done' => 1]);

		break;

	case 'removeRegister':

		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$_s->query("DELETE FROM `register` WHERE `id` = '{$_POST['uid']}'");

		$_f->_json(['done' => 1]);

		break;

	case 'registerInfo':

		if (!isset($_COOKIE['login']) || !isset($_POST['id'])) {
			$_f->json(['done'=>0]);
			break;
		}

		$check = $_s->query("SELECT *, COUNT(*) AS `total` FROM `register` WHERE `id` = '".$_s->escapeString($_POST['id'])."'")->fetchArray(1);

		if ($check['total'] == 1) {

			$co = file_get_contents ( LIB . 'co-co.json' );
			$co = json_decode ( $co, 1 );

			$ct = file_get_contents ( LIB . 'municipios.json' );
			$ct = json_decode ( $ct, 1 );

			$regData = json_decode ( $check ['data'], 1 );
			$regData ['paycardDate'] = date ( 'd / m / Y', $regData ['paycardDate'] );
			$regData ['registered'] = date ( 'd / m / Y H:s', $regData ['registered'] );

			$teData = json_decode ( $check ['tenants'], 1 );

			foreach ( $teData as $k => $v ) {

				$formatBirth = strtotime ( "{$v['birthYear']}-{$v['birthMonth']}-{$v['birthDay']}" );
				$teData [$k] ['birth'] = date ( 'd / m / Y', $formatBirth );
				$nat = array_values(array_filter($co, function ( $a ) use ( $v ) {
					return $a ['alpha3Code'] === $v ['nationality'];
				}));
				$teData [$k] ['nationality'] = [
					'name' => $nat [0] ['translations'] [$_f->getLang()] ?? $nat [0] ['demonym'] ?? '--',
					'flag' => $nat [0] ['flags'] ['png'] ?? ''
				];
				$teData [$k] ['city'] = $v ['city'] ? $ct [$v ['city']] : '';
				$country = array_values(array_filter($co, function ( $a ) use ( $v ) {
					return $a ['alpha3Code'] === $v ['country'];
				}));
				$teData [$k] ['country'] = $country [0] ['translations'] [$_f->getLang()] ?? $country [0] ['demonym'] ?? '--';
				$teData [$k] ['phone'] [1] = $v ['phone'] [1] ?? '';

			}

			$data = [
				'done' 			=> 1,
				'ref' 			=> empty($check ['ref'])?'--':$check ['ref'],
				'checkin' 		=> empty($check ['checkin']) ? '--' : date( 'd / m / Y', $check ['checkin'] ),
				'reservation' 	=> empty($check ['reservation'])?'--':$check ['reservation'],
				'start' 		=> date ( 'd / m / Y', $check ['start'] ),
				'end' 			=> date ( 'd / m / Y', $check ['end'] ),
				'data' 			=> $regData,
				'tenants' 		=> $teData,
				'apartment'		=> '--'
			];

			$apart = $_s->query("SELECT *, COUNT(*) AS `total` FROM `apartment` WHERE `ref` = '{$data['ref']}'")->fetchArray(1);

			if ($apart['total'] == 1) {

				$data ['apartment'] = $apart ['name'];

			}

			$_f->_json($data);

		} else {

			$_f->_json(['done' => 0]);

		}

		break;

	case 'loadRegister':

		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		$check = $_s->query("SELECT *, COUNT(*) AS `total` FROM `register` WHERE `id` = '".$_s->escapeString($_POST['uid'])."'")->fetchArray(1);

		if ($check['total'] == 1) {

			$_f->_json([
				'done' => 1,
				'data' => [
					'id' => $check['id'],
					'ref' => $check['ref'],
					'reservation' => $check['reservation'],
					'checkin' => !empty($check['checkin']) ? date('d / m / Y', $check['checkin']) : '',
					'start' => date('d / m / Y', $check['start']),
					'end' => date('d / m / Y', $check['end']),
					'data' => json_decode($check['data'], 1),
					'tenants' => json_decode($check['tenants'], 1)
				]
			]);

		} else {

			$_f->_json(['done' => 0]);

		}

		break;

	case 'publicTenant':

		if ( !isset ( $_POST ['tenant'] ) || !count ( $_POST ['tenant'] ) ) {
			$_f->_json ( ['done' => 0] );
			break;
		}

		foreach ( $_POST ['tenant'] as $k => $v ) {

			$v = json_decode ( $v, 1 );
			$v ['name'] = mb_convert_case ( $v ['name'], MB_CASE_TITLE, 'UTF-8' );
			$v ['surname'] = mb_convert_case ( $v ['surname'], MB_CASE_TITLE, 'UTF-8' );
			$v ['secondsurname'] = mb_convert_case ( $v ['secondsurname'], MB_CASE_TITLE, 'UTF-8' );
			$v ['birth'] = (int) strtotime ( "{$v ['birthYear']}-{$v ['birthMonth']}-{$v ['birthDay']}" );
			$v ['adress'] [0] = mb_convert_case ( $v ['adress'] [0], MB_CASE_TITLE, 'UTF-8' );
			$v ['adress'] [1] = mb_convert_case ( $v ['adress'] [1], MB_CASE_TITLE, 'UTF-8' );
			$v ['locality'] = mb_convert_case ( $v ['locality'], MB_CASE_TITLE, 'UTF-8' );
			$v ['email'] = strtolower ( $v ['email'] );

			$_POST ['tenant'] [$k] = $v;

		}

		$_POST ['tenant'] = json_encode ( $_POST ['tenant'], JSON_UNESCAPED_UNICODE );

		$_s->query("UPDATE `register` SET `tenants` = '".$_s->escapeString($_POST['tenant'])."' WHERE `id` = '".$_s->escapeString($_POST['id'])."'");

		$_f->_json([
			'done' => 1
		]);

		break;

	case 'newTenant':

		if ( !isset ( $_POST ['ref'] ) || empty ( $_POST ['ref'] ) ) {
			$_f->_json ( ['done' => 0] );
			break;
		}

		if ( !isset ( $_POST ['tenant'] ) || !count ( $_POST ['tenant'] ) ) {
			$_f->_json ( ['done' => 0] );
			break;
		}

		if (
			( !isset ( $_POST ['date'] ['entry'] ) || empty ( $_POST ['date'] ['entry'] ) ) &&
			( !isset ( $_POST ['date'] ['exit'] ) || empty ( $_POST ['date'] ['exit'] ) )
		) {
			$_f->_json ( ['done' => 0] );
			break;
		}

		foreach ( $_POST ['tenant'] as $k => $v ) {

			$v = json_decode ( $v, 1 );
			$v ['name'] = mb_convert_case ( $v ['name'], MB_CASE_TITLE, 'UTF-8' );
			$v ['surname'] = mb_convert_case ( $v ['surname'], MB_CASE_TITLE, 'UTF-8' );
			$v ['secondsurname'] = mb_convert_case ( $v ['secondsurname'], MB_CASE_TITLE, 'UTF-8' );
			$v ['birth'] = (int) $v ['birth'];
			$v ['adress'] [0] = mb_convert_case ( $v ['adress'] [0], MB_CASE_TITLE, 'UTF-8' );
			$v ['adress'] [1] = mb_convert_case ( $v ['adress'] [1], MB_CASE_TITLE, 'UTF-8' );
			$v ['locality'] = mb_convert_case ( $v ['locality'], MB_CASE_TITLE, 'UTF-8' );
			$v ['email'] = strtolower ( $v ['email'] );

			$_POST ['tenant'] [$k] = $v;

		}

		$date = explode ( '/', $_POST ['date'] ['entry'] );
		$_POST ['date'] ['entry'] = (int) strtotime ( "{$date[2]}-{$date[1]}-{$date[0]}" );

		$date = explode ( '/', $_POST ['date'] ['exit'] );
		$_POST ['date'] ['exit'] = (int) strtotime ( "{$date[2]}-{$date[1]}-{$date[0]}" );

		$data = [
			'paymentType' => 'TARJT',
			'paycardDate' => time (),
			'paymentValue' => '',
			'cardOwner' => '',
			'cardExpire' => '',
			'registered' => (int) 0,
			'entry' => '',
			'link' => ''
		];

		do {
			$token = $_f->token();
			$check = $_s->query("SELECT COUNT(*) AS `total` FROM `register` WHERE `data` LIKE '%\"{$token}\"%'" )->fetchArray(1);
			if($check['total']==0){
				$data['link'] = $token;
			}
		} while ( empty($data['link']) );

		$_POST ['tenant'] = json_encode ( $_POST ['tenant'], JSON_UNESCAPED_UNICODE );

		$_s->query("INSERT INTO `register` (`ref`,`checkin`,`reservation`,`start`,`end`,`data`,`tenants`) VALUES (
			'" . $_s->escapeString($_POST['ref']) . "',
			'',
			'',
			'{$_POST['date']['entry']}',
			'{$_POST['date']['exit']}',
			'" . $_s->escapeString(json_encode($data)) . "',
			'" . $_s->escapeString($_POST['tenant']) . "'
		)");

		$_f->_json ( ['done' => 1] );

		break;

	case 'sendTenant':

		if (!isset($_COOKIE['login']) || !isset($_POST['uid'])) {
			$_f->_json(['done' => 0]);
			$_s->close();
			exit();
		}

		if (empty($_f->getConfig('SESentity'))) {
			$_f->_json(['done' => 0, 'msg' => $_f->translate( 'ERRORS.ENTITYMISS' )]);
			break;
		}

		if (empty($_f->getConfig('SESuser'))) {
			$_f->_json(['done' => 0, 'msg' => $_f->translate( 'ERRORS.USERMISS' )]);
			break;
		}

		if (empty($_f->getConfig('SESpass'))) {
			$_f->_json(['done' => 0, 'msg' => $_f->translate( 'ERRORS.PASSMISS' )]);
			break;
		}

		require LIB . 'ses/ses.php';

		$uid = (int) $_POST ['uid'];

		$check = $_s -> query ( "SELECT `ref`, COUNT(*) AS `total` FROM `register` WHERE `id` = '{$uid}' AND `data` LIKE '%\"entry\":\"\"%'" ) -> fetchArray (1);

		if ( !$check ['total'] ) {
			$_f->_json ( ['done' => 0, 'msg' => $_f->translate ( 'ERRORS.SENDED' )] );
			break;
		}

		$check = $_s -> query ( "SELECT `id`, COUNT(*) AS `total` FROM `apartment` WHERE `ref` = '{$check ['ref']}'" ) -> fetchArray (1);

		if ( !$check ['total'] ) {
			$_f->_json ( ['done' => 0, 'msg' => $_f->translate ( 'ERRORS.APART' )] );
			break;
		}

		$data = [
			'apartment'		=> $_s -> query ( "SELECT * FROM `apartment` WHERE `id` = '{$check ['id']}'" ) -> fetchArray (1),
			'register'		=> $_s -> query ( "SELECT * FROM `register` WHERE `id` = '{$uid}'" ) -> fetchArray (1)
		];

		$data ['logData'] = json_decode ( $data ['register'] ['data'], 1 );
		$data ['tenants'] = json_decode ( $data ['register'] ['tenants'], 1 );

		if ( empty ( $data ['apartment'] ['sesid'] ?? '' ) ) {
			$_f->_json ( ['done' => 0, 'msg' => $_f->translate ( 'ERRORS.SESID' )] );
			break;
		}

		if ( empty ( $data ['register'] ['reservation'] ) ) {
			$_f->_json ( ['done' => 0, 'msg' => $_f->translate ( 'ERRORS.RESERVATION' )] );
			break;
		}

		if ( empty ( $data ['register'] ['checkin'] ) ) {
			$_f->_json ( ['done' => 0, 'msg' => $_f->translate ( 'ERRORS.CHECKIN' )] );
			break;
		}

		if ( empty ( $data ['register'] ['start'] ) ) {
			$_f->_json ( ['done' => 0, 'msg' => $_f->translate ( 'ERRORS.START' )] );
			break;
		}

		if ( empty ( $data ['register'] ['end'] ) ) {
			$_f->_json ( ['done' => 0, 'msg' => $_f->translate ( 'ERRORS.END' )] );
			break;
		}

		if ( !count ( $data ['tenants'] ) ) {
			$_f->_json ( ['done' => 0, 'msg' => $_f->translate ( 'ERRORS.TENANTS' )] );
			break;
		}

		$ses = new SES (
			$_f -> getConfig('SESuser'),
			$_f -> getConfig('SESpass'),
			[
				'codigoArrendador'			=> $_f -> getConfig('SESentity'),
				'codigoEstablecimiento' 	=> $data ['apartment'] ['sesid'],
				'tipoOperacion'				=> 'A',
				'tipoComunicacion'			=> 'PV'
			]
		);

		$ses -> setProduction ();

		$collect = [
			'referencia'			=> $data ['register'] ['reservation'],
			'fechaContrato'			=> date ( 'Y-m-d', $data ['register'] ['checkin'] ),
			'fechaEntrada'			=> date ( 'Y-m-d\T15:00:00', $data ['register'] ['start'] ),
			'fechaSalida'			=> date ( 'Y-m-d\T12:00:00', $data ['register'] ['end'] ),
			'numPersonas'			=> (int) count ( $data ['tenants'] ),
			'pago'					=> [
				'tipoPago'			=> $data ['logData'] ['paymentType']
			],
			'persona'				=> []
		];

		if ( !empty ( $data ['logData'] ['paycardDate'] ) ) {
			$collect ['pago'] ['fechaPago'] = date ( 'Y-m-d', $data ['logData'] ['paycardDate'] );
		}

		if ( !empty ( $data ['logData'] ['paymentValue'] ) ) {
			$collect ['pago'] ['medioPago'] = $data ['logData'] ['paymentValue'];
		}

		if ( !empty ( $data ['logData'] ['cardOwner'] ) ) {
			$collect ['pago'] ['titular'] = $data ['logData'] ['cardOwner'];
		}

		if ( !empty ( $data ['logData'] ['cardExpire'] ) ) {
			$collect ['pago'] ['caducidadTarjeta'] = $data ['logData'] ['cardExpire'];
		}

		foreach ( $data ['tenants'] as $v ) {

			if ( empty ( $v ['type'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.TYPE')]);
				break 2;
			}

			if ( empty ( $v ['name'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.NAME')]);
				break 2;
			}

			if ( empty ( $v ['surname'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.SURNAME')]);
				break 2;
			}

			if ( empty ( $v ['docType'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.DOCTYPE')]);
				break 2;
			}

			if ( ( $v ['docType'] === 'DNI' || $v ['docType'] === 'NIE' || $v ['docType'] === 'NIF' ) && empty ( $v ['docNumber'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.DOCNUMBER')]);
				break 2;
			}

			if ( empty ( $v ['birthDay'] ) || empty ( $v ['birthMonth'] ) || empty ( $v ['birthYear'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.BIRTH')]);
				break 2;
			}

			if ( empty ( $v ['adress'] [0] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.ADDRESS')]);
				break 2;
			}

			if ( $v ['country'] === 'ESP' && empty ( $v ['city'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.CITY')]);
				break 2;
			}

			if ( $v ['country'] !== 'ESP' && empty ( $v ['locality'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.LOCALITY')]);
				break 2;
			}

			if ( empty ( $v ['zip'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.ZIP')]);
				break 2;
			}

			if ( empty ( $v ['country'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.COUNTRY')]);
				break 2;
			}

			if ( empty ( $v ['phone'] [0] ) && empty ( $v ['email'] ) ) {
				$_f->_json(['done'=>0,'msg'=>$_f->translate('ERRORS.TENDATA.CONTACT')]);
				break 2;
			}

			if ( !isset ( $v ['birth'] ) || empty ( $v ['birth'] ) ) {
			    $v ['birth'] = strtotime ( "{$v ['birthYear']}-{$v ['birthMonth']}-{$v ['birthDay']}" );
			}

			$per = [
				'rol'					=> $v ['type'],
				'nombre'				=> $v ['name'],
				'apellido1'				=> $v ['surname'],
				'tipoDocumento'			=> $v ['docType'],
				'numeroDocumento'		=> $v ['number'],
				'fechaNacimiento'		=> date ( 'Y-m-d', $v ['birth'] ),
				'direccion'				=> [
					'direccion'			=> $v ['adress'] [0],
					'codigoMunicipio'	=> $v ['city'],
					'codigoPostal'		=> $v ['zip'],
					'pais'				=> $v ['country']
				],
				'telefono'				=> $v ['phone'] [0]
			];

			if ( !empty ( $v ['secondsurname'] ) ) {
				$per ['apellido2'] = $v ['secondsurname'];
			}

			if ( !empty ( $v ['docNumber'] ) ) {
				$per ['soporteDocumento'] = $v ['docNumber'];
			}

			if ( !empty ( $v ['nationality'] ) ) {
				$per ['nacionalidad'] = $v ['nationality'];
			}

			if ( !empty ( $v ['genre'] ) ) {
				$per ['sexo'] = $v ['genre'];
			}

			if ( !empty ( $v ['adress'] [1] ) ) {
				$per ['direccion'] ['direccionComplementaria'] = $v ['adress'] [1];
			}

			if ( !empty ( $v ['locality'] ) ) {
				$per ['direccion'] ['nombreMunicipio'] = $v ['locality'];
			}

			if ( !empty ( $v ['phone'] [0] ) ) {
				$per ['telefono'] = $v ['phone'] [0];
			}

			if ( !empty ( $v ['phone'] [1] ) ) {
				$per ['telefono2'] = $v ['phone'] [1];
			}

			if ( !empty ( $v ['email'] ) ) {
				$per ['correo'] = $v ['email'];
			}

			if ( !empty ( $v ['relation'] ) ) {
				$per ['parentesco'] = $v ['relation'];
			}

			$collect ['persona'] [] = $per;

		}

		$resp = $ses -> alta ( $collect );

		if ( !$resp ['code'] ) {

			$data ['logData'] ['registered'] = (int) time ();
			$data ['logData'] ['entry'] = $resp ['lote'];
			$data ['logData'] = json_encode ( $data ['logData'], JSON_UNESCAPED_UNICODE );
			$_s -> query ( "UPDATE `register` SET `data` = '" . $_s -> escapeString ( $data ['logData'] ) . "' WHERE `id` = '{$uid}'" );

			$_f->_json ( ['done' => 1] );

		} else {

			$_f->_json ( ['done' => 0, 'msg' => $resp ['msg']] );

		}

		break;

}

$_s->close();

?>